<?php
/*
** ===================
** Vankine Service
** Post type : Service;
** version: 1.0;
** Authour : Steeltheme;
** ===================
*/
namespace Vankineaddons\Plugins;
if (! defined('ABSPATH' )){
	die('-1');
}
class Service{
   
	public function __construct() {
		add_action('init', array($this, 'service_custom_post_type'));  
		add_action('init', array($this, 'service_custom_taxonomies')); 
 
	}
	public function service_custom_post_type() {
		register_post_type( 'service',
		array(
			'labels' => array(
				'name' => esc_html_x('Services', 'Post Type General Name', 'vankine-addons') ,
				'singular_name' => esc_html_x('Service', 'Post Type General Name', 'vankine-addons') , 
				'add_new' =>  esc_html__('Add New', 'vankine-addons'),
				'add_new_item' =>   esc_html__('Add New Service', 'vankine-addons'),
				'edit' => esc_html__('Edit', 'vankine-addons'),
				'edit_item' =>   esc_html__('Edit Service', 'vankine-addons'),
				'new_item' =>   esc_html__('New Service', 'vankine-addons'),
				'view' =>  esc_html__('View', 'vankine-addons'),
				'view_item' =>    esc_html__('View Service', 'vankine-addons'),
				'search_items' =>   esc_html__('Search Service', 'vankine-addons'),
				'not_found' =>   esc_html__('No Service found', 'vankine-addons'),
				'not_found_in_trash' =>  esc_html__('No Service found in Trash', 'vankine-addons'),
				'parent' =>  esc_html__('Parent Service', 'vankine-addons')
			),
		
			'public' => true,
			'show_in_rest' => true,
			'menu_position' => 15,
			'supports' => array( 'title', 'editor', 'comments', 'thumbnail', 'excerpt'  ),
			'taxonomies' => array( '' ),
			'show_in_nav_menus'   => true,
			'menu_position'       => 5,
			'menu_icon'           => 'dashicons-format-aside',
			'has_archive' => false,
			'capability_type'    => 'post',
			'hierarchical'          => true,
		)
		 
		);
	}
	public function service_custom_taxonomies() {

		//add new taxonomy hierarchical
		$labels = array(
			'name' =>   esc_html__('Service Categories', 'vankine-addons'),
			'singular_name' =>  esc_html__('Category', 'vankine-addons'),
			'search_items' =>  esc_html__('Search Category', 'vankine-addons'),
			'all_items' =>  esc_html__('All Category', 'vankine-addons'),
			'parent_item' =>  esc_html__('Parent Category', 'vankine-addons'),
			'parent_item_colon' =>   esc_html__('Parent Category:', 'vankine-addons'),
			'edit_item' =>   esc_html__('Edit Category', 'vankine-addons'),
			'update_item' =>   esc_html__('Update Category', 'vankine-addons'),
			'add_new_item' =>  esc_html__('Add New Service Category', 'vankine-addons'),
			'new_item_name' =>   esc_html__('New Category Name', 'vankine-addons'),
			'menu_name' => esc_html__('Categories', 'vankine-addons')
		);
		$args = array(
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'public'             => true,
			'publicly_queryable' => true,
			'show_in_rest' => true,
			'rewrite' => array( 'slug' => 'service_category' )
		);
		register_taxonomy('service_category', array('service'), $args);
		//add new taxonomy NOT hierarchical
	}
}

?>