<?php

namespace  Vankineaddons\Core\Widgets\Post;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Service_carousel_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-service-carousel-v1';
    }

    public function get_title()
    {
        return __('Service Post Carousel  V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['102'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('service_settings',
        [ 
            'label' => __('Service Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );


        $this->add_control(
            'service_style',
            [
                'label' => __('Service style', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one'   => esc_html__( 'Style One', 'vankine-addons' ),
                    'style_two'   => esc_html__( 'Style Two', 'vankine-addons' ),
                    'style_three'   => esc_html__( 'Style Three', 'vankine-addons' ),
                ],
                'default' => 'style_one',
            ]
        );
        $this->add_control(
            'read_more',
            [
                'label' => __( 'Read More', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Read More', 'vankine-addons' ),
            ]
        );
  
        $this->add_control(
            'desktop',
            [
                'label' => __('Carousel Items to Display Desktop', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '3',
            ]
        );
        $this->add_control(
            'tablet',
            [
                'label' => __('Carousel Items to Display Tablet', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '3',
            ]
        );
        $this->add_control(
            'mobile',
            [
                'label' => __('Carousel Items to Display Mobile', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 2,
                'max'     => 10,
                'step'    => 1,
                'default' => '2',
            ]
        );
        $this->add_control(
            'margin',
            [
                'label' => __('Spacing', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 30,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
    
        $this->add_control(
            'post_count',
            [
                'label' => __('Service Count', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
        $this->add_control(
            'text_limits',
            [
                'label'   => esc_html__( 'Text Limit', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
       
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
                    ''       => esc_html__( 'Select', 'vankine-addons' ),
					'date'       => esc_html__( 'Date', 'vankine-addons' ),
					'title'      => esc_html__( 'Title', 'vankine-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'vankine-addons' ),
					'rand'       => esc_html__( 'Random', 'vankine-addons' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
                    ''       => esc_html__( 'Select', 'vankine-addons' ),
					'DESC' => esc_html__( 'DESC', 'vankine-addons' ),
					'ASC'  => esc_html__( 'ASC', 'vankine-addons' ),
				),
			]
        );
      
        $this->add_control(
            'query_category', 
			[
            'type' => \Elementor\Controls_Manager::SELECT2,
			'label' => esc_html__('Category', 'vankine-addons'),
			'options' => vankine_get_service_categories(),
			]
        );

         

    $this->end_controls_section();
    $this->start_controls_section('owl_nav_style',
    [ 
        'label' => __('Owl Nav Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'nav_display',
        [
        'label' => __('Naigation Enable / Disabel', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'nav_true' => __( 'Block', 'vankine-addons' ),
            'nav_false' => __( 'none', 'vankine-addons' ),
        ],
        'default' => __('nav_true' , 'vankine-addons'),
       
        ]
    );
 
    $this->add_control(
        'nav_style_options',
        [
        'label' => __('Nav Move Position', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'position_one' => __( 'Position One', 'vankine-addons' ),
            'position_two' => __( 'Position Two', 'vankine-addons' ),
            'position_three' => __( 'Position Three', 'vankine-addons' ),
            'position_four' => __( 'Position Four', 'vankine-addons' ),
        ],
        'default' => __('position_one' , 'vankine-addons'),
        ]
    );
    $this->add_responsive_control(
        'nav_move_count',
        [
            'label' => __('Nav Move Top', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_two' , 'position_three'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_two .owl-carousel .owl-nav , {{WRAPPER}}  .position_three .owl-carousel .owl-nav ' => 'top: {{VALUE}}px!important;',
            ],
        ]
    );
   
    $this->add_responsive_control(
        'nav_move_prev_left',
        [
            'label' => __('Prev Move Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => 'position_four',
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-prev   ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'nav_move_nest_right',
        [
            'label' => __('Prev Move Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => 'position_four',
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-next   ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );


    $this->add_control(
        'owl_nav_color',
         [
            'label' => __('Owl Nav Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels  .owl-nav i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_bg_color',
         [
            'label' => __('Owl Nav Arrow Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-prev , {{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-next ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    
    $this->add_control(
        'owl_nav_hover_color',
         [
            'label' => __('Owl Nav Hover Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels  .owl-nav .owl-prev:hover i , {{WRAPPER}} .sec_category_carousels  .owl-nav .owl-next:hover i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_hover_bg_color',
         [
            'label' => __('Owl Nav Hover Arrow Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-prev:hover , {{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-next:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 

    $this->end_controls_section();
    $this->start_controls_section('owl_dot_style',
    [ 
        'label' => __('Dot Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    

 
    $this->add_control(
        'dots_display',
        [
        'label' => __('Dots Enable / Disabel', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'dot_true' => __( 'Block', 'vankine-addons' ),
            'dot_false' => __( 'none', 'vankine-addons' ),
        ],
        'default' => 'dot_true' , 
       
        ]
    ); 

    $this->add_responsive_control(
        'dotalignment',
        [
            'label' => esc_html__( 'Alignment', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'dot_left',
        [
            'label' => __('Dot Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'left',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );

    $this->add_control(
        'dot_right',
        [
            'label' => __('Dot Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'right',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );
   

    $this->add_control(
        'dot_color',
         [
            'label' => __('Dot One Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span , {{WRAPPER}}  .slick-dots li button ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 
    $this->add_control(
        'dot_ac_color',
         [
            'label' => __('Dot One Active / Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover span , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span , {{WRAPPER}}  .slick-dots li.slick-active button ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->end_controls_section();

    
    $this->start_controls_section('custom_cssserv',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'icon_color',
         [
            'label' => __('Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box  .icon i  , {{WRAPPER}} .process_box.type_two .icon i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
 
  
   
    $this->add_control(
        'icon_ho_color',
         [
            'label' => __('Icon Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two:hover .content_box .icon i  , {{WRAPPER}} .process_box.type_two:hover .icon i  ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two'] ,
           ],
         ]
    );
    $this->add_control(
        'other_content_color',
         [
            'label' => __('Other Content Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one .content_box .content_inner .steps ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two'] ,
           ],
         ]
    );
    $this->add_control(
        'other_content_ho_colors',
         [
            'label' => __('Other Content Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .steps' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' ],
            ],
         ]
    );

    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .service_box .title_24 a , {{WRAPPER}}  .service_box .title_22 a , {{WRAPPER}} .process_box.type_two .content .title_22 a ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'title_hover_color',
         [
            'label' => __('Title Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .service_box:hover .title_24 a  , {{WRAPPER}}  .service_box:hover .title_22 a , {{WRAPPER}} .process_box.type_two:hover .content .title_22 a ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'desc_color',
         [
            'label' => __('Content Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box p , {{WRAPPER}} .process_box.type_two .content p ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'desc_hover_color',
         [
            'label' => __('Content Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner p , {{WRAPPER}} .process_box.type_two:hover .content p  ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two']
            ],
         ]
    );
    $this->add_control(
        'link_color',
         [
            'label' => __('Link Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one .content_box .content_inner .rd_more svg path  ' => 'stroke: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_one .content_box .content_inner .rd_more  ' => 'stroke: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one']
            ],
         ]
    );
    
    $this->add_control(
        'link_hover_color',
         [
            'label' => __('Link Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [ 
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .rd_more svg path  ' => 'stroke: {{VALUE}}!important;', 
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .rd_more , {{WRAPPER}} .service_box.type_one .content_box .content_inner .rd_more:hover ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'service_style' => ['style_one'] ,
           ],
         ]
    );

    $this->add_control(
        'likt_color_o',
         [
            'label' => __('Link Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_two .content .rd_more  ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_two'] ,
           ],
         ]
    );
   
    $this->add_control(
        'likt_color_t',
         [
            'label' => __('Link Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_two .content .rd_more svg path ' => 'fill: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_two'] ,
           ],
         ]
    );
   
    $this->add_control(
        'likt_color_th',
         [
            'label' => __('Link Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_two:hover .content .rd_more  ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_two'] ,
           ],
         ]
    ); 
    $this->add_control(
        'overlay_color',
         [
            'label' => __('Overlay Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .hover_1 .oh  ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_three' ] ,
           ],
         ]
    );
   
    $this->add_control(
        'box_bg_color',
         [
            'label' => __('Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two , {{WRAPPER}} .service_box.type_one .content_box .content_inner , {{WRAPPER}} .service_box.type_nine
                ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_three'] ,
           ],
         ]
    );
    
    $this->add_control(
        'boxhoverbor_color',
         [
            'label' => __('Box Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one .content_box .content_inner ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one'],
            ],
         ]
    );
    $this->add_control(
        'boxonebor_color',
         [
            'label' => __('Hover Box Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one'],
            ],
         ]
    );
 
    $this->add_control(
        'other_content_ho_color',
         [
            'label' => __('Other Content Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .steps , {{WRAPPER}} .service_box.type_three .content_box .content_box_in .steps ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one'],
            ],
         ]
    );

    
   
   
$this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
     <section class="service_post <?php echo esc_attr($settings['service_style']); ?> position-relative <?php echo esc_attr($settings['nav_style_options']); ?> <?php echo esc_attr($settings['nav_display']); ?> <?php echo esc_attr($settings['dots_display']); ?>">
     <div class="theme_carousel owl-theme owl-carousel" data-options='{"loop": true , "margin": <?php echo esc_attr($settings['margin']); ?>, "autoheight":true, "lazyload":true, "nav": true, "dots": true, "autoplay": false, "autoplayTimeout": 6000,  "smartSpeed": 300, "responsive":{ "0" :{ "items": "1" }, "320" :{ "items" : "1" }, "500" :{ "items" : "1" }, "768" :{ "items" : "<?php echo esc_attr($settings['mobile']); ?>" } , "992":{ "items" : "<?php echo esc_attr($settings['tablet']); ?>" }, "1200":{ "items" : "<?php echo esc_attr($settings['desktop']); ?>" }}}'>
                <?php  
                  $query_args = array(
                        'post_type' => 'service',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'date',
                         
                        'posts_per_page' => $settings['post_count'],
                        'orderby'        => $settings['query_orderby'],
                        'order'          =>  $settings['query_order'],
                    );
                    if($settings['query_category'] ) $query_args['service_category'] = $settings['query_category'];
                     
                        $service_query = new \WP_Query( $query_args );
                    ?>
                    <?php if($service_query->have_posts()):
                            while($service_query->have_posts()) : $service_query->the_post();
                            global $post;
                            $featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
                            $service_icon_type = get_post_meta(get_the_ID() , 'service_icon_type', true);
                            $ser_icon = get_post_meta(get_the_ID() , 'ser_icon', true);
                            $ser_icon_img = get_post_meta(get_the_ID() , 'ser_icon_img', true);
                            $serv_steps = get_post_meta(get_the_ID() , 'serv_steps', true);
                    // while loop start ?>
                    <?php // servie style ?>
						<?php if($settings['service_style'] == 'style_one'): ?>
                    <?php // servie style ?>    
                      
                            <div class="service_box type_one">
                                <?php if(has_post_thumbnail()): ?>
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                        <div class="image"> 
                                            <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                        </div>
                                    </a>
                                <?php endif; ?>
                                <div class="content_box"> 
                                    <div class="content_inner trans">
                                    <?php if($service_icon_type == 'image'): ?>
                                        <?php if(!empty($ser_icon_img['url'])): ?>
                                        <div class="icon trans">
                                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                        </div>
                                        <?php endif; ?>
                                    <?php elseif($service_icon_type == 'icon'): ?>
                                        <div class="icon trans">
                                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(!empty($serv_steps)): ?>
                                        <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                                    <?php endif; ?>
                                    <h4 class="title_24 trans">
                                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                    </h4>
                                    <?php $excerpt = '';
                                    if (has_excerpt()): ?>
                                    <p class="trans">
                                        <?php 
                                            $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                            echo esc_attr($excerpt);
                                        ?>
                                    </p> 
                                    <?php endif; ?>
                                    <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more trans">
                                    <?php echo esc_attr($settings['read_more']); ?>
                                        <svg width="14" height="12" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8 1L13 6M13 6L8 11M13 6H1" stroke="var(--color-white)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>

                                        </a>
                                </div>
                            </div>
                        </div>
                        <?php // servie style ?>
						<?php elseif($settings['service_style'] == 'style_two'): ?>
                    <?php // servie style ?>    
                      
                        <div class="process_box  type_two hover_1_get">
                                    <?php if(has_post_thumbnail()): ?>
                                    <div class="image_box hover_1">
                                        <img src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>"  />
                                        <div class="oh ho_1"></div>
                                        <div class="oh ho_2"></div>
                                        <div class="oh ho_3"></div>
                                        <div class="oh ho_4"></div>
                                        <?php if($service_icon_type == 'image'): ?>
                                            <?php if(!empty($ser_icon_img['url'])): ?>
                                            <div class="icon trans">
                                                <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                            </div>
                                            <?php endif; ?>
                                            <?php elseif($service_icon_type == 'icon'): ?>
                                                <div class="icon trans">
                                                    <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                                </div>
                                            <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <div class="content">
                                        <a class="rd_more trans" href="<?php echo esc_url(get_permalink()); ?>">
                                            <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.60161 0H19.6641C19.9128 0 20.1512 0.0987719 20.327 0.274587C20.5028 0.450403 20.6016 0.68886 20.6016 0.9375V15C20.6016 15.2486 20.5028 15.4871 20.327 15.6629C20.1512 15.8387 19.9128 15.9375 19.6641 15.9375C19.4155 15.9375 19.177 15.8387 19.0012 15.6629C18.8254 15.4871 18.7266 15.2486 18.7266 15V3.2L1.57661 20.35C1.3989 20.5156 1.16384 20.6058 0.920961 20.6015C0.678085 20.5972 0.446354 20.4988 0.274588 20.327C0.102821 20.1553 0.00443133 19.9235 0.000146059 19.6807C-0.00413921 19.4378 0.0860148 19.2027 0.251615 19.025L17.4016 1.875H5.60161C5.35297 1.875 5.11452 1.77623 4.9387 1.60041C4.76289 1.4246 4.66411 1.18614 4.66411 0.9375C4.66411 0.68886 4.76289 0.450403 4.9387 0.274587C5.11452 0.0987719 5.35297 0 5.60161 0Z" fill="white"/>
                                            </svg>
                                        </a> 
                                        <div class="title_22">
                                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                        </div>
                                    <?php $excerpt = '';
                                    if (has_excerpt()): ?>
                                    <p class="trans">
                                        <?php 
                                            $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                            echo esc_attr($excerpt);
                                        ?>
                                    </p> 
                                    <?php endif; ?>
                             
                                    
                                </div>
                            </div>
                        <?php // servie style ?>
						<?php elseif($settings['service_style'] == 'style_three'): ?>
                        <?php // servie style ?>    
                            <div class="service_box type_nine hover_1_get">
                               
                                <div class="content_box"> 
                                    <div class="content_inner trans">
                                    <?php if($service_icon_type == 'image'): ?>
                                        <?php if(!empty($ser_icon_img['url'])): ?>
                                        <div class="icon trans">
                                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                        </div>
                                        <?php endif; ?>
                                    <?php elseif($service_icon_type == 'icon'): ?>
                                        <div class="icon trans">
                                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($service_icon_type == 'image'): ?>
                                        <?php if(!empty($ser_icon_img['url'])): ?>
                                        <div class="icon abs trans">
                                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                        </div>
                                        <?php endif; ?>
                                    <?php elseif($service_icon_type == 'icon'): ?>
                                        <div class="icon abs trans">
                                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                        </div>
                                    <?php endif; ?>
                                    <h4 class="title_24 trans">
                                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                    </h4>
                                    <?php $excerpt = '';
                                    if (has_excerpt()): ?>
                                    <p class="trans">
                                        <?php 
                                            $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                            echo esc_attr($excerpt);
                                        ?>
                                    </p> 
                                    <?php endif; ?>
                                    
                                </div>
                                <?php if(has_post_thumbnail()): ?>
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                        <div class="image hover_1"> 
                                            <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                            <div class="oh ho_1"></div>
                                        <div class="oh ho_2"></div>
                                        <div class="oh ho_3"></div>
                                        <div class="oh ho_4"></div>
                                        </div>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php // servie style ?>

                            <?php // servie style ?>              
                                <?php endif; ?>
                            <?php // servie style ?>                        
	
                    <?php endwhile; // while loop end ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; // Post Endif after loop end  ?>
        </div>
   
   
</section>
 
        <?php
    }
}

         