<?php
namespace  Vankineaddons\Core\Widgets\Post;
if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.
class Portfolio_post_v2 extends \Elementor\Widget_Base{
    public function get_name()
    {
        return 'vankine-portfolio-post-v1';
    }
    public function get_title()
    {
        return __('Portfolio Filter V2' , 'vankine-addons');
    }
    public function get_icon()
    {
        return 'icon-vankine-icon';
    }
    public function get_categories()
    {
        return ['102'];
    }
    protected function register_controls(){
        $this->start_controls_section(
            'portfolio_set_content',
            [
                'label' => __('Portfolio Settings', 'vankine-addons')
            ]
        );
       
        $this->add_control(
            'portfolio_style',
            [
                'label' => __('Portfolio style', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::SELECT,
                'options' => [ 
                    'style_one'  => __('Style One ', 'vankine-addons'),
                    'style_two' => __('Style Two ', 'vankine-addons'), 
                ],
                'default' => 'style_one', 
            ]
        );
        
        $this->add_control(
            'portfolio_column',
            [
                'label' => __('Column', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'vankine-addons' ),
                    'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'vankine-addons' ),
                    'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'vankine-addons' ),
                    'col-xl-12'   => esc_html__( 'One Column', 'vankine-addons' ),
                ],
                'default' => 'col-xl-3 col-lg-4 col-md-6 col-sm-6',
               
            ]
        );
        $repeater_portfolio = new \Elementor\Repeater();
        $repeater_portfolio->add_control(
        'post_count',
        [ 
            'label'   => esc_html__( 'Number of post', 'vankine-addons' ),
            'type'    =>  \Elementor\Controls_Manager::NUMBER,
            'default' => 9,
            'min'     => 1,
            'max'     => 100,
            'step'    => 1,
        ]); 
        $repeater_portfolio->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'vankine-addons' ),
                'type'    =>  \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'vankine-addons' ),
                    'title'      => esc_html__( 'Title', 'vankine-addons' ),
                    'menu_order' => esc_html__( 'Menu Order', 'vankine-addons' ),
                    'rand'       => esc_html__( 'Random', 'vankine-addons' ),
                ),
            ]
        );
        $repeater_portfolio->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'vankine-addons' ),
                'type'    =>  \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'vankine-addons' ),
                    'ASC'  => esc_html__( 'ASC', 'vankine-addons' ),
                ),
            ]
        );
        $repeater_portfolio->add_control(
            'text_limits',
            [
                'label'   => esc_html__( 'Text Limit', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $repeater_portfolio->add_control(
            'post_id',
            [
               'label' => __('Enter the Post Id to dispay', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('', 'vankine-addons'),
               'placeholder' => __('Enter the post id like this -> 1054 , 103 , 11', 'vankine-addons'),    
            ]
        ); 
        $repeater_portfolio->add_control(
            'post_not_in',
            [
               'label' => __('Enter the Post Id that do not dispay', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('', 'vankine-addons'),
               'placeholder' => __('Enter the post id like this -> 154 , 103 , 11', 'vankine-addons'),    
            ]
        ); 
        $repeater_portfolio->add_control(
            'query_category', 
			[
            'type' => \Elementor\Controls_Manager::SELECT,
            'label_block' => true,
            'multiple' => true,
			'label' => esc_html__('Category', 'vankine-addons'),
			'options' => vankine_get_portfolio_categories(),
			]
        );
        $repeater_portfolio->add_responsive_control(
            'filtertitle',
            [
               'label' => __('Filter Button Title', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => __('vankine', 'vankine-addons'),
               'placeholder' => __('Type your title here', 'vankine-addons'),    
            ]
        );
        $this->add_control(
            'project_filter_repeater',
            [
                'label' => __('Portfolio Content', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_portfolio->get_controls(),
                'default' => [
                    [
                        'filtertitle' => 'Category' , 
                    ],  
                ],
                'title_field' => '{{{ filtertitle }}}', 
            ]
        ); 
        $this->end_controls_section();
        $this->start_controls_section('portfoliofilt_box_css',
            [ 
                'label' => __('Filter Tab Css', 'vankine-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
            );
            $this->add_responsive_control(
                'filter_alignment',
                [
                    'label' => esc_html__( 'Filter Alignment', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'options' => [
                        'start' => [
                            'title' => esc_html__( 'Left', 'vankine-addons' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'vankine-addons' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'end' => [
                            'title' => esc_html__( 'Right', 'vankine-addons' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'default' => 'center',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .fliter_group ' => 'text-align: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'filter_color',
                [
                    'label' => __('Filter Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .fliter_group li   ' => 'color: {{VALUE}}!important;',
                    ],
                ]
            );
           
          
            
            $this->add_control(
                'hrsvnfilt',
                [
                    'type' =>  \Elementor\Controls_Manager::DIVIDER,
                ] 
            );
            $this->add_control(
                'filter_color_hover',
                [
                    'label' => __('Filter Hover / Active Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                     'selectors' => [
                        '{{WRAPPER}} .fliter_group li:hover , {{WRAPPER}} .fliter_group li.current ' => 'color: {{VALUE}}!important;',
                      ],
                ]
            );
            $this->add_control(
                'filter_color_hover_bg',
                [
                    'label' => __(' Filter  Hover / Active Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                     'selectors' => [
                        '{{WRAPPER}} .fliter_group li:hover , {{WRAPPER}} .fliter_group li.current ' => 'background: {{VALUE}}!important;',
                      ],
                ]
            ); 
            $this->end_controls_section();
            $this->start_controls_section('custom_cssfil',
            [ 
                'label' => __('Custom Css', 'vankine-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
            );
            $this->add_group_control(
                \Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'borderpro',
                    'selector' => '{{WRAPPER}} .portfolio_box.type_one .image_box , {{WRAPPER}} .portfolio_box.type_two  ',
                ]
            ); 
            $this->add_control(
                'titles_color',
                [
                    'label' => __('Title Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one .title_22 a , {{WRAPPER}} .portfolio_box.type_two .title_30  a ,  {{WRAPPER}} .portfolio_box.type_one .title_22 a span:after , {{WRAPPER}} .portfolio_box.type_two .title_30  a span:after ' => 'color: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label' => __('Description Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_two .content_box p , {{WRAPPER}} .portfolio_box.type_one .content_box  p   ' => 'color: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'zoom_icon_color',
                [
                    'label' => __('Zoom Icon Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .zm_btn  ' => 'color: {{VALUE}}!important;',
                    ],

                ]
            );
            $this->add_control(
                'zoom_icon_bg_color',
                [
                    'label' => __('Zoom Icon Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .zm_btn  ' => 'background: {{VALUE}}!important;',
                    ],

                ]
            );
            $this->add_control(
                'read_more_color',
                [
                    'label' => __('Link Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .lnk svg path ' => 'stroke: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'read_morebg_color',
                [
                    'label' => __('Link Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .lnk ' => 'background: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'over_lay_color',
                [
                    'label' => __('Overlay Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}}  .portfolio_box .hover_1 .oh , {{WRAPPER}} .portfolio_box.type_two .bg ' => 'background: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'box_bg',
                [
                    'label' => __('Box Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one .content_box .content_box_in' =>  'background: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one', 
                    ]
                ]
            );

            $this->add_control(
                'hrsvn',
                [
                    'type' =>  \Elementor\Controls_Manager::DIVIDER,
                
                ]
            );
            $this->add_control(
                'portfolios_image_height',
                [
                    'label' => esc_html__( 'portfolio Image Height', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 2000,
                    'step' => 1,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .image_box img ' => 'height: {{VALUE}}px!important;',
                    ],
                ]
            );
            $this->add_control(
                'hrsix',
                [
                    'type' =>  \Elementor\Controls_Manager::DIVIDER,
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );

            $this->add_control(
                'header_hos_color',
                [
                    'label' => __('Heading Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .title_22 a , {{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .title_22 a span:after  ' => 'color:{{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ],
                ]
            );
            $this->add_control(
                'desc_ho_color',
                [
                    'label' => __('Description Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in p ' => 'color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );
            $this->add_control(
                'box_hov_color',
                [
                    'label' => __('Box Bg Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in ' => 'background: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );
            $this->add_control(
                'link_ho_color',
                [
                    'label' => __('Link Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .lnk svg path ' => 'stroke: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );
            $this->add_control(
                'link_bg_ho_color',
                [
                    'label' => __('Link Hove Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .lnk ' => 'background: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            ); 
            $this->end_controls_section();
}
protected function render(){
$settings = $this->get_settings_for_display();
?>

<section class="portfolio_post_section">
  
      <div class="fliter_group">
        <ul class="portfolio_filter  d_flex clearfix">
          <li data-filter="*" class="current"><?php echo esc_html__( 'Show All' , 'vankine-addons'); ?></li>
          <?php if (!empty($settings['project_filter_repeater'])) {
       foreach($settings['project_filter_repeater'] as $key => $value) { 
        if(!empty($value['query_category'])){
        ?>
          <li data-filter=".project_category-<?php echo esc_attr($value['query_category']);?>">
            <?php echo esc_attr($value['filtertitle']); ?></li>
          <?php }}} ?>
        </ul>
     
  </div> 
<div class="portfoliocontainer clearfix">
    <div class="row">
    <?php if (! empty($settings['project_filter_repeater'])):
       foreach ($settings['project_filter_repeater'] as $key => $value ):
        $post_count  = ! empty( $value['post_count'] ) ? $value['post_count'] : '';
        $query_orderby  = ! empty( $value['query_orderby'] ) ? $value['query_orderby'] : '';
        $query_order  = ! empty( $value['query_order'] ) ? $value['query_order'] : '';
        if(get_query_var('paged')){ 
            $paged = get_query_var( 'paged' ); 
        } elseif ( get_query_var( 'page' ) ) { 
            $paged = get_query_var( 'page' ); 
        } else { 
            $paged = 1; 
        }
        $rpost_not_in = '';
        if(!empty($value['post_not_in'])){
            $rpost_not_in = explode(',', $value['post_not_in']);
        }
        $post_id = '';
        if(!empty($value['post_id'])){
            $post_id = explode(',', $value['post_id']);
        }
        $args = array(
            'post_type' => 'portfolio',
            'ignore_sticky_posts' => true, 
            'paged'             => $paged,
            'posts_per_page' => $post_count,
            'orderby'        =>  $query_orderby,
            'order'          =>  $query_order,
            'post__in'         => $post_id,  
            'post__not_in'   =>  $rpost_not_in,
        );
        if ($value['query_category']) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field'    => 'slug',
                    'terms'    => $value['query_category'],
                ),
            );
        }  
        $portfolio_grid_query = new \WP_Query( $args ); 
        ?>
        <?php while ($portfolio_grid_query->have_posts()) : ?>
        <?php $portfolio_grid_query->the_post(); ?>
        <?php global $post;  
        // portfolio card ?>
        <div class="portfolio-wrapper <?php echo esc_attr($settings['portfolio_column']); ?> project_category-<?php echo esc_attr($value['query_category']);?>">
         <?php if($settings['portfolio_style'] == 'style_one'):?>
            <div class="portfolio_box type_one hover_1_get">
                <div class="image_box hover_1">
                    <?php the_post_thumbnail(); ?>
                    <a data-fancybox="gallery" class="zm_btn trans"
                        href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>">
                        <span class="fi-rs-cursor-plus zoom_icon"></span>
                    </a>
                    <div class="oh ho_1"></div>
                    <div class="oh ho_2"></div>
                    <div class="oh ho_3"></div>
                    <div class="oh ho_4"></div>
                </div>
                <div class="content_box">
                    <div class="content_box_in  trans">
                        <?php the_title( '<h2 class="title_22"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>' ); ?>
                        <?php $excerpt = '';
                        if (has_excerpt()): ?>
                            <p>
                            <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $value['text_limits']));
                                echo esc_attr($excerpt);
                            ?>
                            </p> 
                        <?php endif; ?>
                        <a href="<?php echo esc_url(get_permalink()); ?>" class="lnk trans">
                            <svg class="trans" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1 7.75H16M16 7.75L9.25 1M16 7.75L9.25 14.5" stroke="#008BF9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        <?php elseif($settings['portfolio_style'] == 'style_two'): ?>
            <div class="portfolio_box type_two">
                <div class="image_box ">
                    <?php the_post_thumbnail(); ?>
                    <a data-fancybox="gallery" class="zm_btn trans"
                        href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>">
                        <span class="fi-rs-cursor-plus zoom_icon"></span>
                    </a>
                </div>
         
                 
                <div class="content_box  trans">
                <div class="bg trans"></div>
                    <div class="con">
                        <?php the_title( '<h2 class="title_30"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>' ); ?>
                        <?php $excerpt = '';
                        if (has_excerpt()): ?>
                            <p>
                            <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $value['text_limits']));
                                echo esc_attr($excerpt);
                            ?>
                            </p> 
                        <?php endif; ?>
                    </div>
                    <a href="<?php echo esc_url(get_permalink()); ?>" class="lnk trans">
                        <svg class="trans" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 7.75H16M16 7.75L9.25 1M16 7.75L9.25 14.5" stroke="#008BF9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>
                </div>
            </div>
        <?php endif; ?>
        </div>
        <?php // portfolio card end ?>
        <?php endwhile; ?>
        <?php wp_reset_postdata(); ?>  

    <?php endforeach; ?>
    <?php endif; ?> 
    </div>   
</div>
      
</section>

<?php
    }
}