<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Social_media_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-social-media-v1';
    }

    public function get_title()
    {
        return __('Social Media V1' , 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    

    protected function register_controls() {

		$this->start_controls_section(
			'media_content',
			[
				'label' => esc_html__( 'Media Content', 'vankine-addons' ),
			]
        );
       
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'media_icon',
        [
            'label' => esc_html__('Media Icon', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('fa-brands fa-facebook' , 'vankine-addons'),
        ]);
       
        
        $repeater->add_control(
            'media_link',
            [
                'label' => __('Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'vankine-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );
      
      $this->add_control(
        'media_repeater',
        [
            'label' => __('Media Repeater', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'media_icon' =>  __('fa-brands fa-facebook','vankine-addons'),
                ],
                [
                    'media_icon' =>  __('fa-brands fa-twitter','vankine-addons'),
                ],
                [
                    'media_icon' =>  __('fa-brands fa-skype','vankine-addons'),
                ],
                [
                    'media_icon' =>  __('fa-brands fa-instagram','vankine-addons'),
                ]
                
            ],
            'title_field' => '{{{ media_icon }}}',
        ]);


        
        $this->add_responsive_control(
            'media_alignments',
            [
                'label' => __('Media alignments', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                  'left' => [
                    'title' => __( 'Text Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                  ],
                  'center' => [
                    'title' => __( 'Text Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                  ],
                  'right' => [
                    'title' => __( 'Text Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                  ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                  '{{WRAPPER}} .social-icons ' => 'text-align: {{VALUE}}!important;',
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section('css_changing',
        [ 
            'label' => __('Style', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]);
  
        $this->add_control(
          'color_one',
          [
              'label' => __( 'Color  One', 'vankine-addons' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                  '{{WRAPPER}} .social-icons ul li .m_icon ' => 'color: {{VALUE}}',
              ],
          ]
      );
  
      $this->add_control(
          'color_two',
          [
              'label' => __( 'Color  Two', 'vankine-addons' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                  '{{WRAPPER}} .social-icons ul li .m_icon ' => 'background: {{VALUE}}!important',
              ],
          ]
      );

      $this->add_control(
        'media_font_weights',
        [
            'label' => __('Icon Font Weight', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '400'   => esc_html__( '400', 'vankine-addons' ),
                '500'   => esc_html__( '500', 'vankine-addons' ),
                '600'   => esc_html__( '600', 'vankine-addons' ), 
                '700'   => esc_html__( '700', 'vankine-addons' ), 
                '800'   => esc_html__( '800', 'vankine-addons' ), 
                '900'   => esc_html__( '900', 'vankine-addons' ), 
            ],
            'default' => '400',
            'selectors' => [
                '{{WRAPPER}} .mobile-social-icon  i' => 'font-weight: {{VALUE}}',
            ],
        ]
    );
    $this->add_control(
        'color_three',
        [
            'label' => __( 'Icon Hover Color', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .social-icons ul li .m_icon:hover ' => 'color: {{VALUE}}',
            ],
        ]
    );
    
    $this->add_control(
        'color_four',
        [
            'label' => __( 'Icon Hover Bg Color', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .social-icons ul li .m_icon:hover ' => 'background: {{VALUE}}!important',
            ],
        ]
    );
    $this->add_responsive_control(
        'border_radiuse',
        [
            'label' => __( 'Border Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .social-icons ul li .m_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'padding',
        [
            'label' => __( 'Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .social-icons ul li ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );

    $this->add_control(
        'font_familyss',
        [
            'label' => __('Font Family', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'Font Awesome 5 Brands'   => esc_html__( 'Font Awesome 5 Brands', 'vankine-addons' ),
                'Font Awesome 5 Free'   => esc_html__( 'Font Awesome 5 Free', 'vankine-addons' ),
                'FontAwesome'   => esc_html__( 'FontAwesome', 'vankine-addons' ),
                
            ],
            'default' => 'Font Awesome 5 Brands',
            'selectors' => [
                '{{WRAPPER}} .mobile-social-icon i' => 'font-family: {{VALUE}}',
            ],
        ]
    );
  
      
      $this->end_controls_section();
        
       
	}
    protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
  
		?>

<div class="social-icons">
                       
<ul>
        <?php foreach($settings['media_repeater'] as $media): 
              $mtarget = $media['media_link']['is_external'] ? ' target="_blank"' : '';
              $mnofollow = $media['media_link']['nofollow'] ? ' rel="nofollow"' : '';
            ?>
            <li><a href="<?php echo esc_url($media['media_link']['url']); ?>"  class="m_icon"  <?php echo esc_attr($mtarget); ?> <?php echo esc_attr($mnofollow); ?>> <i class="<?php echo esc_attr($media['media_icon']); ?>"></i>
              
            </a></li>
        <?php endforeach; ?>
        </ul>
</div>
 
	
		<?php 
	}
}

 