<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Progress_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-progress-v1';
    }

    public function get_title()
    {
        return __('Progress  V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
    // style one start
    $this->start_controls_section('progress_content',
    [ 
        'label' => __('Progress Content', 'vankine-addons'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
    );
    $this->add_control(
        'heading',
        [
            'label' => __('Heading', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Consultion', 'vankine-addons'),
            'placeholder' => __('Enter the text here', 'vankine-addons'),
        ]
    );

    $this->add_control(
        'percentage',
        [
            'label' => __('Progress Percentage', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 100,
            'step'    => 1,
            'default' => '3',
        ]
    );
     
    $this->end_controls_section();

    $this->start_controls_section('custom_cssprogress',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'titlecolor',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress_bar .title_no_a_18 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'percolor',
         [
            'label' => __('Percentage Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress_bar  .d-flex div ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'bar_bgcolor',
         [
            'label' => __('Bar Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress_bar .bar ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'bar_borcolor',
         [
            'label' => __('Bar Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress_bar .bar ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'active_bg',
         [
            'label' => __('Bar Active Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress_bar .bar .bar-inner ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
<div class="progress_bar">
        <div class="d-flex align-items-center">
            <h6 class="title_no_a_18"><?php echo esc_attr($settings['heading']); ?> </h6>
            <div> <span  class="count"><?php echo esc_attr($settings['percentage']); ?></span><?php echo esc_html('%' , 'vankine-addons'); ?></div>
        </div>
   <div class="bar">
      <div class="bar-inner  count-bar" data-percent="<?php echo esc_attr($settings['percentage']); ?>%"></div>
   </div>
</div>
 
<?php
    }
}

         