<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Price_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-price-v1';
    }

    public function get_title()
    {
        return __('Price V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('price_settins',
        [ 
            'label' => __('Price Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'tag',
            [
               'label' => __('Tag', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Popular', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
          );
   
        $this->add_control(
          'title',
          [
             'label' => __('Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Standard Plan', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),    
          ]
        );

        
        $this->add_control(
            'price_symbol',
            [
               'label' => __('Price Symbol', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('$', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
        );
        
        $this->add_control(
            'price',
            [
               'label' => __('Price', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('39.83', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
        );
        $this->add_control(
            'price_duration',
            [
               'label' => __('Price Duration', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Monthly', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
        );
        $repeater = new \Elementor\Repeater(); 
        $repeater->add_control(
            'check_no',
            [
                'label' => esc_html__( 'Yes / No', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $repeater->add_control(
            'features_text',
            [
               'label' => __('Text', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Cake & Milk', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
          );
          

        $this->add_control(
            'features_repeater',
            [
                'label' => __('Features  Repeater', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'check_no' => __('yes', 'vankine-addons'),
                        'features_text'  =>  __('Invoices/Estimates', 'vankine-addons'), 
                    ], 
                    [
                        'check_no' => __('yes', 'vankine-addons'),
                        'features_text'  =>  __('Invoices/Estimates', 'vankine-addons'), 
                    ], 
                    [
                        'check_no' => __('yes', 'vankine-addons'),
                        'features_text'  =>  __('Invoices/Estimates', 'vankine-addons'), 
                    ], 
                    [
                        'check_no' => __('yes', 'vankine-addons'),
                        'features_text'  =>  __('Invoices/Estimates', 'vankine-addons'), 
                    ], 
                    [
                        'check_no' => __('yes', 'vankine-addons'),
                        'features_text'  =>  __('Invoices/Estimates', 'vankine-addons'), 
                    ]
                ],
                'title_field' => '{{{ features_text }}}',
            ]
        );
    

        $this->add_control(
            'button_text',
            [
               'label' => __('Button Text', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Select plan', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
        );
        
        $this->add_control(
          'link',
          [
              'label' => __('Link', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::URL,
              'placeholder' => __('https://your-link.com', 'vankine-addons'),
              'show_external' => true,
              'default' => [
                  'url' => '#',
                  'is_external' => false,
                  'nofollow' => false,
              ],
          ]
      );
 

      

    $this->end_controls_section();

    $this->start_controls_section('price_css',
    [ 
        'label' => __('Price Box Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'price_bg_color',
         [
            'label' => __('Price Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'price_tagbg_color',
         [
            'label' => __('Price Box Tag Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .tag  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'price_tag_color',
         [
            'label' => __('Price Box Tag Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .tag  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'price_title_color',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .title_24 a , {{WRAPPER}} .price_box.type_one .title_24 a span:after  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'price_color',
         [
            'label' => __('Price Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .top .price ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'month_color',
         [
            'label' => __('Month Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .top .price small ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'border_color',
         [
            'label' => __('Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .center ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'fi_colro',
         [
            'label' => __('Feature Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .center .d-flex svg path.one' => 'fill: {{VALUE}}!important;',
            ],
         ]
    );
    
    $this->add_control(
        'fi_colrotwo',
         [
            'label' => __('Feature No Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .center .d-flex i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

      
    $this->add_control(
        'fi_colrobg',
         [
            'label' => __('Feature No Icon Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .center .d-flex i ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
   
    $this->add_control(
        'f_colro',
         [
            'label' => __('Feature  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .center .d-flex small ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
   
    $this->add_control(
        'btncolor',
         [
            'label' => __('Button  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .bottom a , {{WRAPPER}} .price_box.type_one .bottom a svg path ' => 'color: {{VALUE}}!important; fill: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'btnbgcolor',
         [
            'label' => __('Button Bg  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .bottom a ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hobtnhocolro',
         [
            'label' => __('Button Hover  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .bottom a:hover  , {{WRAPPER}} .price_box.type_one .bottom a svg path '  => 'color: {{VALUE}}!important; fill: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hobtnbgcolor',
         [
            'label' => __('Button Hover Bg  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .price_box.type_one .bottom a:hover ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;',
            ],
         ]
    );

  
    $this->add_responsive_control(
        'border_radius',
        [
            'label' => __( 'Button Border Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px'],
            'selectors' => [
                '{{WRAPPER}} .theme_btn   ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
);
   
    $this->end_controls_section();

}
protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');  
    $target = $settings['link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['link']['nofollow'] ? ' rel="nofollow"' : ''; 
?>
<div class="price_box type_one trans">
    <?php if(!empty($settings['tag'])): ?>
    <div class="tag"><?php echo wp_kses($settings['tag'] , $allowed_tags); ?></div>
    <?php endif; ?>
    <div class="top">
        <h4 class="title_24">
            <a class="links" href="<?php echo esc_url($settings['link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>> 
                <?php echo wp_kses($settings['title'] , $allowed_tags); ?>
            </a>
        </h4> 
        <div class="price">
            <sub> <?php echo wp_kses($settings['price_symbol'] , $allowed_tags); ?></sub><?php echo wp_kses($settings['price'] , $allowed_tags); ?><small><?php echo esc_html('/', 'vankine-addons');?> <?php echo wp_kses($settings['price_duration'] , $allowed_tags); ?></small>
        </div>
    </div>
    <div class="center">
        <?php foreach($settings['features_repeater'] as  $key => $features_repeater): ?>
            <div class="d-flex align-items-center">
                <?php if($features_repeater['check_no'] == 'yes'): ?>
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_185_1985)">
                    <path class="one" d="M10 0C4.48578 0 0 4.48578 0 10C0 15.5142 4.48578 20 10 20C15.5142 20 20 15.5142 20 10C20 4.48578 15.5142 0 10 0Z" fill="#2196F3"/>
                    <path d="M15.0692 7.88074L9.6525 13.2973C9.48999 13.4598 9.27667 13.5416 9.06335 13.5416C8.85004 13.5416 8.63672 13.4598 8.47421 13.2973L5.76593 10.589C5.44 10.2632 5.44 9.73651 5.76593 9.41074C6.09171 9.08481 6.61829 9.08481 6.94421 9.41074L9.06335 11.5299L13.8909 6.70245C14.2167 6.37653 14.7433 6.37653 15.0692 6.70245C15.395 7.02823 15.395 7.55481 15.0692 7.88074Z" fill="#FAFAFA"/>
                    </g>
                    <defs>
                    <clipPath id="clip0_185_1985">
                    <rect width="20" height="20" fill="white"/>
                    </clipPath>
                    </defs>
                </svg>

                <?php else: ?>
                    <i class="fa fa-times"></i>
                <?php endif; ?>
                <small><?php echo wp_kses($features_repeater['features_text'] , $allowed_tags); ?></small>
            </div>
        <?php endforeach; ?>
    </div>
    <div class="bottom text-center">
        <a class="theme_btn" href="<?php echo esc_url($settings['link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                <?php echo wp_kses($settings['button_text'] , $allowed_tags); ?>
                <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 11L11 1M11 1H3.5M11 1V8.5" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>

        </a>
    </div>
</div>
  
         <?php

    }
}

 