<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Image_box_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-image-box-v1';
    }

    public function get_title()
    {
        return __('Image Box V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('image_box_settings',
        [ 
            'label' => __('Image Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'image_style',
            [
            'label' => __('Image Box Styles', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'vankine-addons' ),
                'style_two' => __( 'Style Two', 'vankine-addons' ),
                'style_three' => __( 'Style Three', 'vankine-addons' ),
                'style_four' => __( 'Style Four', 'vankine-addons' ),
                'style_five' => __( 'Style Five', 'vankine-addons' ),
                'style_six' => __( 'Style Six', 'vankine-addons' ),
                'style_seven' => __( 'Style Seven', 'vankine-addons' ),
                'style_eight' => __( 'Style Eight', 'vankine-addons' ),
            ],
            'default' => 'style_one' , 
            ]
        );

        
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
               
            ] 
        );
         
        $this->add_control(
            'image_two',
            [
                'label' => __( 'Image Two', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'image_style' => ['style_one' , 'style_two' , 'style_three' , 'style_four'] ,
                ],
            ] 
        );
        $this->add_control(
            'image_three',
            [
                'label' => __( 'Image Three', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'image_style' => ['style_two' , 'style_three'] ,
                ],
            ] 
        );
        $this->add_control(
            'image_four',
            [
                'label' => __( 'Image Four', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'image_style' => ['style_two'] ,
                ],
            ] 
        );
        $this->add_control(
            'shape_enable',
            [
                'label' => __('Shape Enable / Disable', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'icon_box_style' => 'style_one'
                ],
            ]
        );
        $this->add_control(
            'authout_image',
            [
                'label' => __( 'Authour Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'image_style' => ['style_four'] ,
                ],
            ] 
        );
        $this->add_control(
            'authour',
            [
               'label' => __('Authour', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Wilcoxon', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),  
               'condition' => [
                'image_style' => ['style_four' , 'style_six' , 'style_seven' , 'style_eight'] ,
                ],  
            ]
        );

        $this->add_control(
            'authour_text',
            [
               'label' => __('Authour Text', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('We’re Best Insurance Company', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),  
               'condition' => [
                'image_style' => ['style_four' , 'style_six' , 'style_seven'] ,
                ],  
            ]
        );
        $this->add_control(
            'video_link',
            [
                'label' => __('Video Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('https://youtu.be/RN81h85V6D4', 'vankine-addons'),
                'placeholder' => __('Enter the Video Link ', 'vankine-addons'),
                'condition' => [
                    'image_style' => ['style_five' , 'style_six'] ,
                ],  
            ]
        );

        $this->add_responsive_control(
            'link',
            [
                'label' => __('Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'vankine-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'image_style' => ['style_seven' , 'style_eight'] ,
                ],  
            ]
        );
    
    $this->end_controls_section();

    $this->start_controls_section('custom_cssimagebox',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );

    $this->add_control(
        'styimgcolor',
         [
            'label' => __('Shape Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image_box_only  svg path ' => 'fill: {{VALUE}}!important;',
                '{{WRAPPER}} .image_box_only.type_two .bg , {{WRAPPER}} .image_box_only.type_five .content:before , {{WRAPPER}} .image_box_only.type_five .content:after ' => 'background: {{VALUE}}!important;',
            ], 
            'condition' => [
                'image_style' => ['style_one' , 'style_two' , 'style_seven'] ,
            ],
         ]
    );
 
    $this->add_control(
        'image_height',
        [
            'label' => __('Image Height', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '',
            'min'     => 1,
            'max'     => 5000,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .image_video_box_only.type_one img  , {{WRAPPER}} .image_video_box_only.type_one .image ,
                {{WRAPPER}} .image_box_only.type_six  img  , {{WRAPPER}} .image_box_only.type_six .image  ,
                {{WRAPPER}} .image_box_only.type_five  img  , {{WRAPPER}} .image_box_only.type_five .image  ,
                {{WRAPPER}} .image_video_box_only.type_two .image  ' => 'height: {{VALUE}}px!important;', 
            ],
            'condition' => [
                'image_style' => ['style_five' , 'style_six' , 'style_seven' , 'style_eight'] ,
            ],
        ]
    );

    $this->add_control(
        'colorone',
         [
            'label' => __('Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image_box_only.type_four .abso_content .authour_box .title_no_a_18 
                ,   {{WRAPPER}} .image_video_box_only.type_two .fun_facts .title_no_a_18 , {{WRAPPER}} .title_no_a_30 , {{WRAPPER}}  .title_no_a_20 ' => 'color: {{VALUE}}!important;',
            ], 
            'condition' => [
                'image_style' => ['style_four' , 'style_six'  , 'style_seven' , 'style_eight'] ,
            ],
         ]
    );

    $this->add_control(
        'colortwo',
         [
            'label' => __('Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image_box_only.type_four .abso_content .authour_box .title_no_a_26 , {{WRAPPER}} .image_video_box_only.type_two .fun_facts .title_no_a_26 , {{WRAPPER}} .title_16 a  ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .image_box_only.type_four .abso_content .authour_box .title_no_a_26:after  ,  {{WRAPPER}}  .image_video_box_only.type_two .fun_facts .title_no_a_26:before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'image_style' => ['style_four' , 'style_six'  , 'style_seven'] ,
            ],
         ]
    );

    $this->add_control(
        'link_bg_color',
         [
            'label' => __('Link Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .title_16 a svg path  , {{WRAPPER}} .image_box_only.type_six svg.one path ' => 'stroke: {{VALUE}}!important;',
            ],
            'condition' => [
                'image_style' => ['style_seven' , 'style_eight'] ,
            ],
         ]
    );

    $this->add_control(
        'link_bg',
         [
            'label' => __('Link Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .title_16 a svg circle , {{WRAPPER}} .image_box_only.type_six svg.one circle ' => 'fill: {{VALUE}}!important;',
            ],
            'condition' => [
                'image_style' => ['style_seven' , 'style_eight'] ,
            ],
         ]
    );

    $this->add_control(
        'colorbg',
         [
            'label' => __('Background', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image_box_only.type_four .abso_content .authour_box  , 
                {{WRAPPER}} .image_video_box_only.type_two .fun_facts , {{WRAPPER}} .image_box_only.type_six .content ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'image_style' => ['style_four' , 'style_six' ,  'style_eight'] ,
            ],
         ]
    );
    $this->add_control(
        'colorbgr',
         [
            'label' => __('Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image_box_only.type_six .content::before ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .image_box_only.type_six .content svg path' => 'fill: {{VALUE}}!important;',
            ],
            'condition' => [
                'image_style' => ['style_eight'] ,
            ],
         ]
    );


    $this->add_control(
        'video_bg_color',
         [
            'label' => __('Video Btn Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image_video_box_only.type_one .video_box , {{WRAPPER}} .image_video_box_only.type_two .image .video_box a ' => 'background: {{VALUE}}!important;',
                '{{WRAPPER}} .image_video_box_only.type_one .video_box::before  ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'image_style' => ['style_five' , 'style_six'] ,
            ],
         ]
    );

    $this->add_control(
        'video_i_color',
         [
            'label' => __('Video Btn Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image_video_box_only.type_one .video_box .lightbox-image  , {{WRAPPER}} .image_video_box_only.type_two .image .video_box a ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'image_style' => ['style_five' , 'style_six'] ,
            ],
         ]
    );
    

     
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        
     ?>
        
    <?php // style ?>
    <?php if($settings['image_style'] == 'style_one'):  ?>
    <?php // style ?>

    <div class="image_box_only  type_one">
        <?php global $vankine_theme_mod;
            $rtl_enable = isset( $vankine_theme_mod['rtl_enable'] ) ? $vankine_theme_mod['rtl_enable'] : '';
            if(is_rtl() || $rtl_enable == true){ ?>
             <svg width="584" height="361" viewBox="0 0 584 361" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M71.9881 27.9446C133.6 34.2751 157.756 86.6367 195.736 42.1471C207.079 28.8672 214.432 15.8049 227.046 7.85635C263.059 -14.8308 295.745 39.7147 329.83 21.6142C351.567 10.0692 382.433 -12.2949 423.179 11.4556C444.119 23.6643 452.178 43.9955 462.815 68.4992C485.02 119.645 531.966 120.301 565.875 171.855C594.801 215.844 585.651 261.738 549.363 282.861C507.627 307.166 465.925 290.991 408.623 284.117C358.157 278.064 342.547 321.316 295.915 349.769C263.725 369.405 227.53 361.394 196.078 339.164C154.963 310.102 139.995 276.977 120.764 237.902C99.527 194.736 69.8604 182.433 44.2421 166.375C-34.9545 116.728 5.56738 21.1282 71.9881 27.9446Z" fill="#2D947A"/>
            </svg>
            <?php } else{ ?>
                <svg width="584" height="361" viewBox="0 0 584 361" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M511.94 27.9446C450.328 34.2751 426.172 86.6367 388.192 42.1471C376.849 28.8672 369.496 15.8049 356.881 7.85635C320.869 -14.8308 288.183 39.7147 254.098 21.6142C232.361 10.0692 201.495 -12.2949 160.749 11.4556C139.809 23.6643 131.75 43.9955 121.113 68.4992C98.9077 119.645 51.9621 120.301 18.0526 171.855C-10.8735 215.844 -1.72306 261.738 34.5651 282.861C76.3006 307.166 118.003 290.991 175.305 284.117C225.771 278.064 241.38 321.316 288.013 349.769C320.203 369.405 356.398 361.394 387.85 339.164C428.965 310.102 443.933 276.977 463.164 237.902C484.401 194.736 514.067 182.433 539.686 166.375C618.882 116.728 578.36 21.1282 511.94 27.9446Z" fill="#2D947A"/>
                </svg>
            <?php } ?>
        <?php if(!empty($settings['image']['url'])): ?>
            <div class="image one">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
            </div>
        <?php endif; ?>       
        <?php if(!empty($settings['image_two']['url'])): ?>
            <div class="image two">
                <img src="<?php echo esc_url($settings['image_two']['url']); ?>" alt="img" />
            </div>
        <?php endif; ?>          
    </div>
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_two'):  ?>
    <?php // style ?>
    <div class="image_box_only  type_two">
     <div class="bg"></div>
     <div class="left">
        <?php if(!empty($settings['image']['url'])): ?>
            <div class="image one">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
            </div>
        <?php endif; ?>       
        <?php if(!empty($settings['image_two']['url'])): ?>
            <div class="image two">
                <img src="<?php echo esc_url($settings['image_two']['url']); ?>" alt="img" />
            </div>
        <?php endif; ?>   
    </div> 
    <div class="right">
        <?php if(!empty($settings['image_three']['url'])): ?>
            <div class="image three">
                <img src="<?php echo esc_url($settings['image_three']['url']); ?>" alt="img" />
            </div>
        <?php endif; ?>    
        <?php if(!empty($settings['image_four']['url'])): ?>
            <div class="image four">
                <img src="<?php echo esc_url($settings['image_four']['url']); ?>" alt="img" />
            </div>
        <?php endif; ?>          
    </div>
    </div> 
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_three'):  ?>
    <?php // style ?>
    <div class="image_box_only  type_three">
        <div class="left">
            <?php if(!empty($settings['image']['url'])): ?>
                <div class="image one">
                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                </div>
            <?php endif; ?>       
            <?php if(!empty($settings['image_two']['url'])): ?>
                <div class="image two">
                    <img src="<?php echo esc_url($settings['image_two']['url']); ?>" alt="img" />
                </div>
            <?php endif; ?>   
        </div> 
        <div class="right">
            <?php if(!empty($settings['image_three']['url'])): ?>
                <div class="image three">
                    <img src="<?php echo esc_url($settings['image_three']['url']); ?>" alt="img" />
                </div>
            <?php endif; ?>       
        </div>
    </div> 
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_four'):  ?>
    <?php // style ?>
    
        <div class="image_box_only  type_four">
            <?php if(!empty($settings['image']['url'])): ?>
                <div class="image">
                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                </div>
            <?php endif; ?>    
            <div class="abso_content">
                <?php if(!empty($settings['image_two']['url'])): ?>   
                    <img src="<?php echo esc_url($settings['image_two']['url']); ?>" class="imtwo" alt="img" />
                <?php endif; ?>  

                <div class="authour_box">
                    <div class="d-flex align-items-center">
                        <?php if(!empty($settings['authout_image']['url'])): ?>   
                            <img src="<?php echo esc_url($settings['authout_image']['url']); ?>" alt="img" />
                        <?php endif; ?>  
                        <?php if(!empty($settings['authour'])): ?>
                            <h6 class="title_no_a_18"><?php echo wp_kses($settings['authour'] , $allowed_tags); ?></h6>
                        <?php endif; ?>  
                    </div>
                    <?php if(!empty($settings['authour_text'])): ?>
                        <h6 class="title_no_a_26"><?php echo wp_kses($settings['authour_text'] , $allowed_tags); ?></h6>
                    <?php endif; ?>  
                </div>
            </div>
        </div> 
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_five'):  ?>
    <?php // style ?>

    <div class="image_video_box_only  type_one">
        <?php if(!empty($settings['image']['url'])): ?>
            <div class="image one">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                <?php if(!empty($settings['video_link'])) :?>
                    <div class="video_box video-inner text-center">
                        <a href="<?php echo esc_html($settings['video_link']); ?>" class="lightbox-image">
                            <i class="fi-rr-play"></i>
                        </a>
                    </div>
                <?php endif ?>
            </div>
        <?php endif; ?>       
    </div>
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_six'):  ?>
    <?php // style ?>

    <div class="image_video_box_only  type_two">
        <?php if(!empty($settings['image']['url'])): ?>
            <div class="image one">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                <?php if(!empty($settings['video_link'])) :?>
                    <div class="video_box video-inner text-center">
                        <a href="<?php echo esc_html($settings['video_link']); ?>" class="lightbox-image">
                            <i class="fi-rr-play"></i>
                        </a>
                    </div>
                <?php endif ?>
                <div class="fun_facts type_two">
                    <?php if(!empty($settings['authour'])): ?>
                         <h6 class="title_no_a_18"><?php echo wp_kses($settings['authour'] , $allowed_tags); ?></h6>
                    <?php endif; ?>  
                    <?php if(!empty($settings['authour_text'])): ?>
                        <h6 class="title_no_a_26"><?php echo wp_kses($settings['authour_text'] , $allowed_tags); ?></h6>
                    <?php endif; ?>  
                </div>
            </div>
        <?php endif; ?>       
    </div>
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_seven'): 
          $target = $settings['link']['is_external'] ? ' target="_blank"' : '';
          $nofollow = $settings['link']['nofollow'] ? ' rel="nofollow"' : '';
        ?>
    <?php // style ?>

    <div class="image_box_only  type_five">
        <?php if(!empty($settings['image']['url'])): ?>
            <div class="image one">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                <?php if(!empty($settings['video_link'])) :?>
                    <div class="video_box video-inner text-center">
                        <a href="<?php echo esc_html($settings['video_link']); ?>" class="lightbox-image">
                            <i class="fi-rr-play"></i>
                        </a>
                    </div>
                <?php endif ?>
                <div class="content">
                    <?php if(!empty($settings['authour'])): ?>
                         <h6 class="title_no_a_30"><?php echo wp_kses($settings['authour'] , $allowed_tags); ?></h6>
                    <?php endif; ?>  
                    <?php if(!empty($settings['authour_text'])): ?>
                        <h6 class="title_16">
                        <a href="<?php echo esc_url($settings['link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                            <svg width="55" height="55" viewBox="0 0 55 55" fill="none" class="one" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="28" cy="27" r="20" fill="white"/>
                                <circle cx="27.5" cy="27.5" r="27.5" fill="white" fill-opacity="0.1"/>
                                <path d="M22 33.25L33.25 22M33.25 22H24.8125M33.25 22V30.4375" stroke="#2D947A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <?php echo wp_kses($settings['authour_text'] , $allowed_tags); ?>
                            </a>
                        </h6>
                    <?php endif; ?>  
                </div>
            </div>
        <?php endif; ?>       
    </div>
    <?php // style ?>
    <?php elseif($settings['image_style'] == 'style_eight'): 
         $target = $settings['link']['is_external'] ? ' target="_blank"' : '';
         $nofollow = $settings['link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
    <?php // style ?>

    <div class="image_box_only  type_six">
        <?php if(!empty($settings['image']['url'])): ?>
            <div class="image one">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                <?php if(!empty($settings['video_link'])) :?>
                    <div class="video_box video-inner text-center">
                        <a href="<?php echo esc_html($settings['video_link']); ?>" class="lightbox-image">
                            <i class="fi-rr-play"></i>
                        </a>
                    </div>
                <?php endif ?>
                <div class="content text-center">
                <a href="<?php echo esc_url($settings['link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>  
                    <svg width="55" height="55" viewBox="0 0 55 55" fill="none" class="one" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="28" cy="27" r="20" fill="white"/>
                        <circle cx="27.5" cy="27.5" r="27.5" fill="white" fill-opacity="0.1"/>
                        <path d="M22 33.25L33.25 22M33.25 22H24.8125M33.25 22V30.4375" stroke="#2D947A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <?php if(!empty($settings['authour'])): ?>
                         <h6 class="title_no_a_20"><?php echo wp_kses($settings['authour'] , $allowed_tags); ?></h6>
                    <?php endif; ?>  
                    <svg width="71" height="7" viewBox="0 0 71 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M61.3463 7C58.7897 7 57.4874 5.61327 56.3384 4.38975C55.301 3.28482 54.4815 2.41206 52.7303 2.41206C50.979 2.41206 50.1595 3.28482 49.1219 4.38975C47.9731 5.61327 46.6709 7 44.1141 7C41.5573 7 40.2553 5.61327 39.1063 4.38975C38.0689 3.28482 37.2495 2.41206 35.4983 2.41206C33.7472 2.41206 32.9278 3.28482 31.8905 4.38975C30.7416 5.61327 29.4394 7 26.8826 7C24.3262 7 23.0243 5.61327 21.8755 4.38975C20.8383 3.28482 20.0189 2.41206 18.268 2.41206C16.517 2.41206 15.6976 3.28482 14.6602 4.38975C13.5114 5.61327 12.2091 7 9.65253 7C7.09575 7 5.79352 5.61327 4.64453 4.38975C3.60713 3.28482 2.78775 2.41206 1.03653 2.41206C0.464193 2.41206 0 1.87216 0 1.20603C0 0.540101 0.464193 0 1.03653 0C3.59314 0 4.89537 1.38673 6.04436 2.61025C7.08176 3.71518 7.90131 4.58794 9.65253 4.58794C11.4036 4.58794 12.223 3.71518 13.2604 2.61045C14.4092 1.38673 15.7114 0 18.268 0C20.8244 0 22.1265 1.38693 23.2753 2.61045C24.3125 3.71538 25.1317 4.58794 26.8826 4.58794C28.6338 4.58794 29.4532 3.71518 30.4906 2.61045C31.6394 1.38673 32.9417 0 35.4983 0C38.0551 0 39.3571 1.38673 40.5061 2.61045C41.5435 3.71518 42.3631 4.58794 44.1141 4.58794C45.8655 4.58794 46.6849 3.71518 47.7223 2.61045C48.8713 1.38673 50.1735 0 52.7303 0C55.287 0 56.5893 1.38673 57.7383 2.61045C58.7757 3.71518 59.595 4.58794 61.3463 4.58794C63.0978 4.58794 63.9174 3.71518 64.9551 2.61025C66.1041 1.38673 67.4065 0 69.9635 0C70.5358 0 71 0.540101 71 1.20603C71 1.87216 70.5358 2.41206 69.9635 2.41206C68.2119 2.41206 67.3924 3.28482 66.3546 4.38975C65.2056 5.61327 63.9034 7 61.3463 7Z" fill="white"/>
                    </svg>
                    </a>
                </div>
            </div>
        <?php endif; ?>       
    </div>
    <?php // style ?>
    <?php endif; ?>
    <?php // style ?>


    <?php
    }
}

 

