<?php
   
namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

   class Faqs_v1 extends \Elementor\Widget_Base
   {
   
       public function get_name()
       {
           return 'vankine-faqs-v1';
       }
   
       public function get_title()
       {
           return __('Faqs V1', 'vankine-addons');
       }
   
       public function get_icon()
       {
        return 'icon-vankine-icon';
       }
   
       public function get_categories()
       {
           return ['101'];
       }
   
       protected function register_controls(){
   
            $this->start_controls_section('faq_settings',
            [ 
               'label' => __('Faq Settings', 'vankine-addons')
            ]
            );
           
            $repeater = new \Elementor\Repeater();
   
            $repeater->add_control(
               'faq_icons',
               [
                   'label' => __('Faqs Icon', 'vankine-addons'),
                   'type' => \Elementor\Controls_Manager::ICON,
                   'options' => vankine_get_icon(),
                   'default' => __('fi-rs-arrow-small-right' , 'vankine-addons'),
                  
               ]
            );
     
   
            $repeater->add_control(
               'faqsheading_text',
               [
                   'label' => __('Faqs Heading', 'vankine-addons'),
                   'type' => \Elementor\Controls_Manager::TEXTAREA,
                   'default' => __('How do I make a yearly payment? ', 'vankine-addons'),
                   'placeholder' => __('How do I make a yearly payment?', 'vankine-addons'),
               ]
            );
   
      
         
            $repeater->add_control(
               'faqsdescription',
               [
                   'label' => __('Faqs Description', 'vankine-addons'),
                   'type' => \Elementor\Controls_Manager::TEXTAREA,
                   'default' => __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'vankine-addons'),
                   'placeholder' => __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'vankine-addons'),
               ]
            );
   
            $repeater->add_control(
             'hrfourre',
             [
                 'type' => \Elementor\Controls_Manager::DIVIDER, 
                
             ]
            );
   
           $repeater->add_control(
             'faqs_active_tb',
            [
               'label' => __('Faq Active / Deactive', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
         );
     
           $this->add_control(
               'faqs_v1_repeater',
               [
                   'label' => __('Faqs Box Content', 'vankine-addons'),
                   'type' => \Elementor\Controls_Manager::REPEATER,
                   'fields' => $repeater->get_controls(),
                   'default' => [
                       [
                        'faq_icons' =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                        'faqsheading_text' =>  __('How do I make a yearly payment?', 'vankine-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.'),
                        'faqs_active_tb' => 'yes',
                        ],
                       [
                        'faq_icons' =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                        'faqsheading_text' =>  __('How this technology works?', 'vankine-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'vankine-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                        [
                        'faq_icons' =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                        'faqsheading_text' =>  __('What is the comunity benefit?', 'vankine-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'vankine-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                        [
                        'faq_icons' =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                        'faqsheading_text' =>  __('What is the comunity benefit?', 'vankine-addons'),
                        'faqsdescription' =>  __('Serenity Is Multi-Faceted Blockchain Based Ecosystem, Energy Retailer For The People, Focusing On The Promotion Of Sustainable Living, Renewable Energy Production And Smart Energy Grid Utility Services.', 'vankine-addons'),
                        'faqs_active_tb' => 'no',
                        ],
                   ],
                   'title_field' => '{{{ faqsheading_text }}}',
   	
               ]
           );
    
    $this->end_controls_section();

    
    $this->start_controls_section('custom_css',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .faq_header .question_box .title_no_a_18 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    
    $this->add_control(
        'content_color',
         [
            'label' => __('Content Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .answer' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'arrow_color',
         [
            'label' => __('Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .faq_header .question_box .icon_fq ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'arrow_bg_color',
         [
            'label' => __('Arrow Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .faq_header .question_box .icon_fq ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'acarrow_color',
         [
            'label' => __('Active / Hover Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .faq_header.active .question_box .icon_fq , {{WRAPPER}} .block_faq .faq_header:hover .question_box .icon_fq ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'acarrow_bg_color',
         [
            'label' => __('Active / Hover Arrow Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .faq_header.active .question_box .icon_fq , {{WRAPPER}} .block_faq .faq_header:hover .question_box .icon_fq' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'background_color',
         [
            'label' => __('Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .faq_header , {{WRAPPER}} .block_faq .answer ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'border_color',
         [
            'label' => __('Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .block_faq .faq_header , {{WRAPPER}} .block_faq .answer' => 'border-color: {{VALUE}}',
            ],
         ]
    );
 
    
    
   
$this->end_controls_section();

}
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
?> 
 
   <section class="block_faq">
      <div class="accordion">
        <?php foreach($settings['faqs_v1_repeater'] as  $key => $faqs_block):?>
            <div class="question  faq_header <?php if($faqs_block['faqs_active_tb'] == 'yes'): echo  esc_attr('active'); endif;?>">
                <div class="question_box ">
                    <div class="title_no_a_18 trans"><?php echo wp_kses($faqs_block['faqsheading_text'] , $allowed_tags);?></div>
                    <span class="icon_fq trans <?php echo esc_attr($faqs_block['faq_icons']);?>"></span>
                </div>
            </div>
            <div class="answer accordion-content"  <?php if($faqs_block['faqs_active_tb'] == 'yes'):?> style="display:block;" <?php endif;?>>
                <?php echo wp_kses($faqs_block['faqsdescription'] , $allowed_tags);?>
            </div> 
        <?php endforeach;?>
      </div>
   </section>
 
<?php
}
}
 