<?php 
namespace Vankineaddons\Core;
class Functions{
	  /**
      * Instantiate the object.
      *
      * @since 1.0.0
      *
      * @return void
      */
      public function __construct() {
		add_shortcode('vankine-mega-menu', [$this, 'vankine_render_megamenu']);
		add_shortcode('vankine-header', [$this, 'vankine_render_header']);
		add_shortcode('vankine-footer', [$this, 'vankine_render_footer']);
	}
	/*
	** ============================== 
	**   vankineheader
	** ==============================
	*/ 
		
	public function vankine_render_header($atts, $content = '') {
		if (defined('ICL_SITEPRESS_VERSION')) {
            $post_id = apply_filters('wpml_object_id', $atts['id'], 'header', true);
        } elseif (function_exists('pll_get_post')) {
            // Check if Polylang is active
            $post_id = pll_get_post($atts['id'], pll_current_language());
        } else {
            // No translation plugins are active, use the provided ID
            $post_id = $atts['id'];
        }  
		$query_args = array(
			'p' => $atts['id'],
			'post_type' => 'header',
		);
		$post_query = new \WP_Query($query_args);  if ($post_query->have_posts()) {
            while ($post_query->have_posts()) {
                $post_query->the_post();
                // Check if Elementor plugin is active
                if ( class_exists( 'Elementor\Plugin' ) ) {
                    // Elementor is active, proceed with using it
                    $headerelementor = \Elementor\Plugin::instance();
                    $header_elementor = $headerelementor->frontend->get_builder_content( $post_id  , true );
                    if ( $header_elementor ) {
                        echo do_shortcode( $header_elementor );
                    } else {
                        echo do_shortcode( get_the_content( null, false, $post_id ) );
                    }
                } else {
                    // Elementor is not active, handle the case accordingly
                    echo do_shortcode( get_the_content( null, false, $post_id ) );
                }
    
                wp_reset_postdata(); 
                return; // Stop processing after outputting the content
            }
        } else {
            // Handle case when no posts match the criteria
            echo '<p>' . esc_html__('Sorry, no posts matched your criteria.', 'woostores-addons') . '</p>';
        } 
	}
	/*
	** ============================== 
	**   vankine megamenu
	** ==============================
	*/ 
		
	public function vankine_render_megamenu($atts, $content = '') {
		  // Check if WPML is active
		  if (defined('ICL_SITEPRESS_VERSION')) {
			$post_id = apply_filters('wpml_object_id', $atts['id'], 'mega_menu', true);
		} elseif (function_exists('pll_get_post')) {
			// Check if Polylang is active
			$post_id = pll_get_post($atts['id'], pll_current_language());
		} else {
			// No translation plugins are active, use the provided ID
			$post_id = $atts['id'];
		}   
		$query_args = array(
			'p'         => $post_id,
			'post_type' => 'mega_menu',
		); 
		$post_query = new \WP_Query($query_args); 
		if ($post_query->have_posts()) {
			while ($post_query->have_posts()) {
				$post_query->the_post(); 
				// Check if Elementor plugin is active
				if ( class_exists( 'Elementor\Plugin' ) ) {
					// Elementor is active, proceed with using it
					$mega_menuelementor = \Elementor\Plugin::instance();
					$mega_menu = $mega_menuelementor->frontend->get_builder_content( $post_id  , true );
					if ( $mega_menu ) {
						echo do_shortcode( $mega_menu );
					} else {
						echo do_shortcode( get_the_content( null, false, $post_id ) );
					}
				} else {
					// Elementor is not active, handle the case accordingly
					echo do_shortcode( get_the_content( null, false, $post_id ) );
				}
			
				wp_reset_postdata(); 
				return; // Stop processing after outputting the content
			}
		} else {
			// Handle case when no posts match the criteria
			echo '<p>' . esc_html__('Sorry, no posts matched your criteria.', 'woostores-addons') . '</p>';
		}
	}
	/*
	** ============================== 
	**   vankinefooter
	** ==============================
	*/ 
	public function vankine_render_footer($atts, $content = '') {
		  // Check if WPML is active
		if (defined('ICL_SITEPRESS_VERSION')) {
			$post_id = apply_filters('wpml_object_id', $atts['id'], 'footer', true);
		} elseif (function_exists('pll_get_post')) {
			// Check if Polylang is active
			$post_id = pll_get_post($atts['id'], pll_current_language());
		} else {
			// No translation plugins are active, use the provided ID
			$post_id = $atts['id'];
		}   
		$query_args = array(
			'p'         => $post_id,
			'post_type' => 'footer',
		); 
		$post_query = new \WP_Query($query_args); 
		if ($post_query->have_posts()) {
			while ($post_query->have_posts()) {
				$post_query->the_post(); 
				// Check if Elementor plugin is active
				if ( class_exists( 'Elementor\Plugin' ) ) {
					// Elementor is active, proceed with using it
					$footerelementor = \Elementor\Plugin::instance();
					$footer_elementor = $footerelementor->frontend->get_builder_content( $post_id  , true );
					if ( $footer_elementor ) {
						echo do_shortcode( $footer_elementor );
					} else {
						echo do_shortcode( get_the_content( null, false, $post_id ) );
					}
				} else {
					// Elementor is not active, handle the case accordingly
					echo do_shortcode( get_the_content( null, false, $post_id ) );
				}
			
				wp_reset_postdata(); 
				return; // Stop processing after outputting the content
			}
		} else {
			// Handle case when no posts match the criteria
			echo '<p>' . esc_html__('Sorry, no posts matched your criteria.', 'woostores-addons') . '</p>';
		}
	}	
}