<?php
/*
=================================
Mobile Header Settings
==================================
*/
Redux::setSection( $opt_name, array(
            'title'  => esc_html__( 'Option Panel Settings', 'vankine' ),
            'id'     => 'option_panel_settings',
            'desc'   => esc_html__( '', 'vankine' ),
            'icon'   => 'el el-th',
            'fields' => array(
                array(
                    'id'       => 'panel_logo',
                    'type'     => 'switch', 
                    'title'    => __('Logo Enable  / Disable', 'vankine'), 
                    'default'  => true,
                ),  
                array(
                    'id'       => 'company_logo_modals',
                    'type'     => 'media', 
                    'url'      => true,
                    'default'  => array(
                        'url'=> get_template_directory_uri() . '/assets/images/theme-logo.png', 
                    ),
                    'title'    => __('Logo', 'vankine'),
                    'required' => array( 'panel_logo', '=', true ),
                 
                ),
                array(
                    'id'       => 'about_company_modal',
                    'type'     => 'textarea',
                    'title'    => esc_html__( 'About Company', 'vankine' ), 
                    'default' => esc_html__('Denounce with righteous indignation and dislike men who are beguiled
                        and demoralized by the charms pleasure moment so blinded desire that
                        they cannot foresee the pain and trouble.', 'vankine') ,
                    'required' => array( 'panel_logo', '=', true ),
                ),

                array(
                    'id'       => 'post_enable_modal',
                    'type'     => 'switch', 
                    'title'    => __('Post Enable', 'vankine'),
                    'default'  => true,
                ),
                array(
                    'id'       => 'post_count',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Post Count', 'vankine' ), 
                    'default' =>  '15'  ,
                    'required' => array( 'post_enable_modal', '=', true ),
                ),

                array(
                    'id'       => 'post_title_modal',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Title', 'vankine' ),
                    'desc'     => esc_html__( '', 'vankine' ),
                    'default' => esc_html__('Latest Portfolio', 'vankine') , 
                    'required' => array( 'post_enable_modal', '=', true ),
                ),
                array(
                    'id'       => 'post_style_modal',
                    'type'     => 'select',
                    'title'    => __('Select Post To Display', 'vankine'),  
                    // Must provide key => value pairs for select options
                    'options'  => array(
                        'service' => esc_html__( 'Service Post', 'vankine' ),   
                        'portfolio' => esc_html__( 'portfolio Post', 'vankine' ),   
                        'post' => esc_html__( 'Post', 'vankine'),   
                    ),
                    'required' => array( 'post_enable_modal', '=', true ),
                ),
                array(
                    'id'       => 'form_enable',
                    'type'     => 'switch', 
                    'title'    => __('Form Enable  / Disable', 'vankine'), 
                    'default'  => true,
                ),  
                array(
                    'id'       => 'form_title',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Form Title', 'vankine' ),
                    'default' => esc_html__('Need Any Help? Or Looking For an Agent', 'vankine') , 
                    'required' => array( 'form_enable', '=', true ),
                ),
                array(
                    'id'       => 'modal_form_short_code',
                    'type'     => 'textarea',
                    'title'    => esc_html__( 'Modal Form Shortcode', 'vankine' ),
                    'desc' => esc_html__('Enter Contact Form 7 Short Code here', 'vankine') ,
                    'placeholder'     => esc_html__( '[contact-form-7 id="344" title="Contact Form"]', 'vankine' ),
                    'required' => array( 'form_enable', '=', true ),
                ),
                array(
                    'id'       => 'contact_panel_enables',
                    'type'     => 'switch', 
                    'title'    => __('Contact Enable  / Disable', 'vankine'), 
                    'default'  => true,
                ), 
                array(
                    'id'       => 'mobile_phone_numbers',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Phone Number', 'vankine' ),
                    'default' => esc_html__('9806071234', 'vankine') ,
                    'required' => array( 'contact_panel_enables', '=', true ),
                ),
                array(
                    'id'       => 'mobile_mail_numbers',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Mail Id', 'vankine' ),
                    'default' => esc_html__('sendmail@example.com', 'vankine') ,
                    'required' => array( 'contact_panel_enables', '=', true ),
                ),
                array(
                    'id'       => 'working_hours_panels',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Working Hours', 'vankine' ),
                    'default' => esc_html__('Working Hours : <span> Sun-monday, 09am-5pm </span>', 'vankine') ,
                    'required' => array( 'contact_panel_enables', '=', true ),
                ),
                array(
                    'id'       => 'copy_right_enable',
                    'type'     => 'switch', 
                    'title'    => __('Copy Right Enable  / Disable', 'vankine'), 
                    'default'  => true,
                ),  
                array(
                    'id'       => 'copy_right_modal',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Copy Right', 'vankine' ),
                    'desc'     => esc_html__( '', 'vankine' ),
                    'default' => esc_html__('© 2022 Vankine. All Rights Reserved.', 'vankine') , 
                    'required' => array( 'copy_right_enable', '=', true ),
                ),
               
    )
));


 