<?php
/*
====================
General Settings
====================
*/
Redux::setSection( $opt_name, array(
            'title'  => esc_html__( 'General Settings', 'vankine' ),
            'id'     => 'general_settings',
            'desc'   => esc_html__( '', 'vankine' ),
            'icon'   => 'el el-wrench',
            'fields' => array(
                array(
                    'id' => 'maintanace_mode',
                    'type' => 'section',
                    'title' => __('Maintenance Mode Section', 'vankine'),
                    'indent' => true ,
                ), 
                array(
                    'id'       => 'enable_maintenance',
                    'type'     => 'switch',
                    'title'    => esc_html__( 'Maintenance Mode Enable / Disable ', 'vankine' ),
                    'default'  => false,
                ), 
                array(
                    'id'       => 'maintenance_image',
                    'type'     => 'media', 
                    'url'      => true,
                    'title'    => __('Maintenance Image', 'vankine'),
                    'required' => [ 'enable_maintenance', '=', true ],
                ),
                array(
                    'id'       => 'maintenance_title',
                    'type'     => 'text', 
                    'default'  =>  __('Site Under Maintenance.', 'vankine'),
                    'title'    => __('Maintenance Title', 'vankine'),
                    'required' => [ 'enable_maintenance', '=', true ],
                ),
                array(
                    'id'       => 'maintenance_description',
                    'type'     => 'textarea', 
                    'default'  =>  __('This website is currently undergoing maintenance.', 'vankine'),
                    'title'    => __('Maintenance Description', 'vankine'),
                    'required' => [ 'enable_maintenance', '=', true ],
                ),
                array(
                    'id' => 'rtl_section',
                    'type' => 'section',
                    'title' => __('Rtl Styling', 'vankine'),
                    'indent' => true ,
                ), 
                array(
                    'id'       => 'rtl_enable',
                    'type'     => 'switch', 
                    'default'  => false,
                    'title'    => __('Rtl Enable /Disable', 'vankine'),
                ), 
                array(
                    'id' => 'body_style_sec',
                    'type' => 'section',
                    'title' => __('Body Styling', 'vankine'),
                    'indent' => true ,
                ), 
                array(
                    'id'       => 'tp_body_padd_css',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Body Padding For Desktop', 'vankine' ), 
                    'default' => esc_html__('0px 0px 0px 0px', 'vankine') , 
                ),

                array(
                    'id'       => 'tp_mbbody_padd_css',
                    'type'     => 'text',
                    'title'    => esc_html__( 'Body Padding For Mobile', 'vankine' ), 
                    'default' => esc_html__('0px 0px 0px 0px', 'vankine') , 
                ),

                array(
                    'id'       => 'tp_body_color',
                    'type'     => 'color',
                    'title'    => __('Body Background Color', 'vankine'), 
                    'validate' => 'color',
                ),
 
                array(
                    'id'       => 'tp_body_image',
                    'type'     => 'media', 
                    'url'      => true,
                    'default'  => array(
                        'url'=> '', 
                    ),
                    'title'    => __('Body Background Image', 'vankine'),     
                ),
                
                array(
                    'id'       => 'border_enable',
                    'type'     => 'switch',
                    'title'    => esc_html__( 'Border Line Enable', 'vankine' ),
                    'default'  => false,
                ),
                 
                //preloader back ti top
                array(
                    'id'       => 'preloader_enables',
                    'type'     => 'switch', 
                    'title'    => __('Preloader Enable  / Disable', 'vankine'),
                    'subtitle' => __('Preloader', 'vankine'),
                    'default'  => false,
                ),  
                
                 array(
                    'id'       => 'preloader_image',
                    'type'     => 'media', 
                    'url'      => true,
                    'default'  => array(
                        'url'=> '', 
                    ),
                    'title'    => __('Preloader Image', 'vankine'),
                    'required' => [ 'preloader_enables', '=', true ],
                ),
             
                array(         
                    'id'       => 'pre_loader_color_one',
                    'type'     => 'color',
                    'title'    => __('Preloader Color One', 'vankine'),
                    'validate' => 'color',
                    'required' => [ 'preloader_enables', '=', true ],
                ),

                array(         
                    'id'       => 'pre_loader_color_two',
                    'type'     => 'color',
                    'title'    => __('Preloader Color Two', 'vankine'),
                    'validate' => 'color',
                    'required' => [ 'preloader_enables', '=', true ],
                ),

                array(         
                    'id'       => 'pre_loader_color_three',
                    'type'     => 'color',
                    'title'    => __('Preloader Color Three', 'vankine'),
                    'validate' => 'color',
                    'required' => [ 'preloader_enables', '=', true ],
                ), 
                array(
                    'id'       => 'bactotop_enable',
                    'type'     => 'switch', 
                    'default'  => false,
                    'title'    => __('Back to top Enable /Disable', 'vankine'),
                ), 
                 
                array(
                    'id'       => 'admin_notice_enable',
                    'type'     => 'switch', 
                    'title'    => __('Admin Panel Notice Enable  / Disable', 'vankine'), 
                    'default'  => true,
                ),   
 
                
            ),
        ));