<?php
/*
====================
Register required plugins
====================
*/
add_action('tgmpa_register', 'vankine_register_required_plugins');
function vankine_register_required_plugins(){
        $plugins = array(
           array(
                'name' => esc_html__('Vankine Addons', 'vankine') ,
                'slug' => 'vankine-addons',
                'source'  => get_template_directory() . '/includes/plugins/vankine-addons.zip',
                'required' => false,
                'force_activation' => false,
                'force_deactivation' => false,
            ) ,
            array(
                'name' => esc_html__('Elementor', 'vankine') ,
                'slug' => 'elementor',
                'required' => false,
                'force_activation' => false,
                'force_deactivation' => false,
            ) ,
            array(
                'name' => esc_html__('Revslider', 'vankine') ,
                'slug' => 'revslider', 
                'source'   =>  'https://themepanthers.com/updatedplugin/revslider.zip',
                'required' => true,
                'force_activation' => false,
                'force_deactivation' => false,
            ) ,
            array(
                'name' => esc_html__('Wp Forms Lite', 'vankine') ,
                'slug' => 'wpforms-lite',
                'required' => false,
                'force_activation' => false,
                'force_deactivation' => false,
            ),
           
            array(
                'name' => esc_html__('MailChimp for WordPress', 'vankine') ,
                'slug' => 'mailchimp-for-wp',
                'required' => false,
                'force_activation' => false,
                'force_deactivation' => false,
            ), 
            array(
                'name' => esc_html__('A Woocommerce', 'vankine') ,
                'slug' => 'woocommerce',
                'required' => false,
                'force_activation' => false,
                'force_deactivation' => false,
            ) ,
        );
        $config = array(
            'id' => 'tgmpa' ,
            'domain' => 'vankine',
            'default_path' => '',
            'menu' => 'install-required-plugins',
            'has_notices' => true,
            'is_automatic' => false,
            'message' => '',
            'strings' => array(
                'page_title' => esc_html__('Install Required Plugins', 'vankine') ,
                'menu_title' => esc_html__('Install Plugins', 'vankine') ,
                'installing' => esc_html__('Installing Plugin: %s', 'vankine') ,
                'oops' => esc_html__('Something went wrong with the plugin API.', 'vankine') ,
                'notice_can_install_required' => _n_noop('This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'vankine') ,
                'notice_can_install_recommended' => _n_noop('This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'vankine') ,
                'notice_cannot_install' => _n_noop('Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'vankine') ,
                'notice_can_activate_required' => _n_noop('The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'vankine') ,
                'notice_can_activate_recommended' => _n_noop('The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'vankine') ,
                'notice_cannot_activate' => _n_noop('Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'vankine') ,
                'notice_ask_to_update' => _n_noop('The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'vankine') ,
                'notice_cannot_update' => _n_noop('Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'vankine') ,
                'install_link' => _n_noop('Begin installing plugin', 'Begin installing plugins', 'vankine') ,
                'activate_link' => _n_noop('Activate installed plugin', 'Activate installed plugins', 'vankine') ,
                'return' => esc_html__('Return to Required Plugins Installer', 'vankine') ,
                'plugin_activated' => esc_html__('Plugin activated successfully.', 'vankine') ,
                'complete' => esc_html__('All plugins installed and activated successfully. %s', 'vankine') ,
                'nag_type' => 'updated'
            )
        );
    tgmpa($plugins, $config);
}

 


