<?php
/*
** ============================== 
**  Vankine Theme main file
** ==============================
*/
add_action('wp_enqueue_scripts', 'vankine_enqueue_scripts_before_install_plugin');
add_action('admin_enqueue_scripts',  'vankine_cat_meta_postbox_css');
add_action('after_setup_theme',  'vankine_setup');
add_action('widgets_init',   'vankine_register_sidebar');
add_action('template_redirect','check_maintenance_mode');
/*
========================
Mainatanance Mode
========================
*/
function check_maintenance_mode() { 
    $enable_maintenance =  get_vankine_option('enable_maintenance');
    if ( $enable_maintenance == true && !current_user_can('manage_options')) {
        include(locate_template('/includes/functions/maintenance-mode.php'));
        exit();
    }
}
/*
==========================================
Helper function to retrieve Redux options
==========================================
*/
function get_vankine_option($option_key, $default = '') {
    global $vankine_theme_mod; 
    if (isset($vankine_theme_mod[$option_key])) {
        return $vankine_theme_mod[$option_key];
    }  
    return $default;
}
/*
========================
includeslude  file
========================
*/
//WP Bootstrap Navwalke
require_once get_template_directory() . '/includes/lib/Vankine_WP_Bootstrap_Navwalker.php';
//plugin activation
require get_template_directory() . '/includes/class-tgm-plugin-activation.php';
require get_template_directory() . '/includes/lib/pluginarrays.php';
require_once get_template_directory() . '/includes/functions/functions.php';
//Redux
if(class_exists('Redux')){
    require get_template_directory() . '/includes/options/config.php';
}
//merlin
require_once get_template_directory() . '/demo-import/class-merlin.php';
require_once get_template_directory() . '/demo-import/merlin-config.php';
require_once get_template_directory() . '/demo-import/merlin-filters.php';
if(class_exists('woocommerce')){  
require_once get_template_directory() . '/includes/functions/woo.php';
}
//Theme Custom Extension
require_once get_template_directory() . '/includes/functions/header-source.php';
require_once get_template_directory() . '/includes/functions/layout.php';
require_once get_template_directory() . '/includes/functions/classes.php';
require_once get_template_directory() . '/includes/functions/extra/breadcrumbs.php';
require_once get_template_directory() . '/includes/functions/extra/comments.php';
require_once get_template_directory() . '/includes/functions/extra/nav.php';
require_once get_template_directory() . '/template-parts/page-header/default-page-header.php';
require_once get_template_directory() . '/template-parts/page-header/page-header.php';
require_once get_template_directory() . '/template-parts/blog-functions.php';
require_once get_template_directory() . '/template-parts/headers/option-panel.php';
//Mobile Menu
require_once get_template_directory() . '/includes/options/inline-functions.php';
require_once get_template_directory() . '/includes/options/typography-css.php';
//custom menu option
require_once get_template_directory() . '/includes/lib/custom-menu-option.php'; 
//Mobile Menu
require_once get_template_directory() . '/template-parts/headers/mobile-menu.php';
if(is_admin()){
    require_once get_template_directory() . '/includes/admin/admin.php';
}
/*
==========================================
Metabox admin styles
==========================================
*/
function vankine_cat_meta_postbox_css(){
    wp_enqueue_style('meta-box-css', get_template_directory_uri().'/assets/css/metabox.css' );
} 
/*
==========================================
Font Loading
==========================================
*/
function vankine_fonts_url() {
    $font_url = '';
    $DMSans = _x( 'on', 'DM Sans font: on or off', 'vankine' );
/* Translators: If there are characters in your language that are not
* supported by Open Sans, translate this to 'off'. Do not translate
* into your own language.
*/
// $Quicksand = _x( 'on', 'Quicksand font: on or off', 'vankine' );
if ( 'off' !== $DMSans) {
            $font_families = array();
    if ( 'off' !== $DMSans ) {
        $font_families[] = 'DM Sans:400,400i,500,500i,700,700i';
    }
    
    $query_args = array(
        'family' => urlencode( implode( '|', $font_families ) ),
        'subset' => urlencode( 'latin,latin-ext' ),
    );
    $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
}
return esc_url_raw( $fonts_url );
}

/*
** ============================== 
** Register and enqueue styles
** ============================== 
*/
add_action('admin_enqueue_scripts', 'vankine_add_admin_scripts');
function vankine_add_admin_scripts() {
    wp_enqueue_style('vankine-meta-box', get_template_directory_uri().'/assets/css/metabox.css' , array() , '1.0.0' , 'all');
}
 
function vankine_enqueue_scripts_before_install_plugin(){
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/plugins/bootstrap.min.css', array() , '5.0.0', 'all');
    wp_enqueue_style('vankine-style', get_template_directory_uri().'/style.css' , array() , time() , 'all');  
    wp_enqueue_style('uicons-regular-rounded', get_template_directory_uri() . '/assets/css/plugins/uicons-regular-rounded.css', array() , '1.0.0', 'all');
    wp_enqueue_style('uicons-regular-straight', get_template_directory_uri() . '/assets/css/plugins/uicons-regular-straight.css', array() , '1.0.0', 'all');
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/css/plugins/font-awesome.min.css', array() , '6.0.0', 'all');
    wp_enqueue_style('flaticon', get_template_directory_uri() . '/assets/css/plugins/flaticon_vankine.css', array() , '1.0.0', 'all');
    wp_enqueue_style('vankinefonts', vankine_fonts_url(), array(), null );
    
    wp_enqueue_style('vankine-main-style', get_template_directory_uri().'/assets/css/theme.css' , array() , time() , 'all');  
    wp_enqueue_script('bootstrap-bundle', get_template_directory_uri() . '/assets/js/plugins/bootstrap.bundle.min.js', array('jquery') , '5.0.0', true);
    wp_enqueue_script('vankine-theme', get_template_directory_uri() . '/assets/js/theme.js', array('jquery') , '1.0.0', true);
    if(is_singular() && comments_open() && get_option('thread_comments')):
        wp_enqueue_script('comment-reply');
    endif;
}   
/*
==========================================
add_theme_support
==========================================
*/
function vankine_setup(){
if(!isset($content_width))
    $content_width = 840;
/*---------- Make theme available for translation-----------*/
    load_theme_textdomain('vankine', get_template_directory() . '/lang');
/*----------Add Theme Support-----------*/
    add_theme_support('post-thumbnails');
    add_theme_support('html5', array(
        'search-form'
    ));
    add_theme_support('title-tag');
    add_theme_support('post_format', ['aside', 'gallery', 'link', 'image', 'quote', 'status', 'video', 'audio', 'chat']);
    add_theme_support('automatic-feed-links');
/*----------woocommerce Theme Support-----------*/ 
    add_theme_support( 'woocommerce');
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
/*----------editor-style-----------*/
    add_editor_style('assets/css/editor-style.css');
/*----------register_nav_menus-----------*/
    register_nav_menus(array(
        'primary' => esc_html__('Primary Menu', 'vankine') , 
    ));
}
/*
==========================================
Register widgetized area and update sidebar with default widgets.
==========================================
*/
function vankine_register_sidebar(){
    $sidebars = array(
        'sidebar-blog' => esc_html__('Blog Sidebar', 'vankine') ,
        'page-sidebar' => esc_html__('Page Sidebar', 'vankine') ,
        'service-sidebar' => esc_html__('Service Sidebar', 'vankine') ,
        'shop-sidebar' => esc_html__('Shop Sidebar', 'vankine') ,
    );
    // Register sidebars
    foreach ($sidebars as $id => $name){
        register_sidebar(
            array(
                'name' => $name,
                'id' => $id,
                'description' => esc_html__('Add widgets here in order to display on pages', 'vankine') ,
                'before_widget' => '<div class="sidebar-widget mb-50"><div id="%1$s" class="widget widget_box  %2$s">',
                'after_widget' => '</div> </div>',
                'before_title' => '<h4 class="widget-title">',
                'after_title' => '</h4>',
            )
        );
    }
} 
 
/**
 * Get Elementor builder content for display.
 *
 * @param int $post_id Post ID of the Elementor builder content.
 * @return string|null The builder content HTML.
 */
function vankine_elementor_builder_content_for_display($post_id) {
    if( empty( $post_id)){
        return;
    }
    $content = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($post_id);
    return  $content;
}
