<?php
/*
** ============================== 
** Vankine Layout
** ==============================
*/
/*
======================================
Display page header
======================================
*/
if(!function_exists('vankine_has_page_header')):
/*
** Check ifcurrent page has page header
** @return bool && get_post_meta(get_the_ID() , 'page_header_enable_disable', true))
*/
function vankine_has_page_header(){
     global $vankine_theme_mod;
     $page_header_options = '';
     if(!empty($vankine_theme_mod['page_header_enable'])):
        $page_header_options =  $vankine_theme_mod['page_header_enable'];
     endif;
        if((is_page()  || is_singular(array('project' , 'service' , 'post' , 'product'))) && get_post_meta(get_the_ID() , 'page_header_enable_disable', true)):
            return false;
        elseif(is_singular('mega-menu')):
            return false;
        elseif(is_singular('header')):
            return false;
        elseif(is_singular('sticky_header')):
            return false;
        elseif(is_singular('footer')):
            return false;
        elseif(is_page_template('template-homepage.php')):
            return false;
        elseif(is_page_template('template-blog.php')):
            return false;
        elseif(is_attachment()):
            return false;
        endif;
        return $page_header_options;
    }
endif;
/*
======================================
Display page header Image
======================================
*/
 add_action('vankine_get_page_header_image' , 'vankine_page_header_image');
    function vankine_page_header_image(){   
         global $vankine_theme_mod;
            if(!vankine_has_page_header()){
                return '';
            }
            if((is_page()  || is_singular(array('post' , 'service' , 'portfolio' , 'product')) || is_post_type_archive('product') || is_tax() || is_tag() || is_day() || is_year() || is_month()  || is_tax( 'product_cat') || is_category())){
                $page_header_bgimages = '';
                if(!empty($vankine_theme_mod['page_header_bg_image']['url'])):
                    $page_header_bgimages = $vankine_theme_mod['page_header_bg_image']['url'];
                endif;
                if(get_post_meta(get_the_ID() , 'page_header_bg_image_showss', true) == true){
                    $page_pg_image = get_post_meta(get_the_ID() , 'page_header_bgimage', true);
                    $page_header_bgimages =  $page_pg_image['url'];
                }
            if(!empty($page_header_bgimages)):
            ?>
            <div class="bakground_cover" style="background-image:url(<?php echo esc_url($page_header_bgimages); ?>)"> 
          
            </div>
            <?php
        endif;  
    } 
    else{
        $page_header_blog = '';
        if(!empty($vankine_theme_mod['blog_page_header_bg_image']['url'])):
            $page_header_blog = $vankine_theme_mod['blog_page_header_bg_image']['url'];
        endif;
        if(!empty($page_header_blog)):
        ?>
        <div class="bakground_cover" style="background-image:url(<?php echo esc_url($page_header_blog); ?>)"> 
        </div>
    <?php endif;   
    }  
}
 
/*
======================================
Display Columns
======================================
*/
if(!function_exists('vankine_get_layout')):
/*
**Get Column base on current page
** @return string
*/
function vankine_get_layout(){
    global $vankine_theme_mod;
    global $post;
    $vankine_layout = 'right-sidebar';
    $page_layouts = 'right-sidebar';
    $service_layouts = 'right-sidebar';
    $layout_shop = 'no-sidebar';
    // options
    if(!empty($vankine_theme_mod['default_layouts'])):
        $vankine_layout = $vankine_theme_mod['default_layouts'];
    endif;
    if(!empty($vankine_theme_mod['page_layouts'])):
        $page_layouts =  $vankine_theme_mod['page_layouts'];
    endif;
    if(!empty($vankine_theme_mod['service_layouts'])):
        $service_layouts =  $vankine_theme_mod['service_layouts'];
    endif;
    if(!empty($vankine_theme_mod['layout_shop'])){
        $layout_shop = $vankine_theme_mod['layout_shop'];
    }
    // options
    if(is_singular() && get_post_meta(get_the_ID() , 'custom_layout', true)):
        $vankine_layout = get_post_meta(get_the_ID() , 'layout', true);
    elseif(is_page()):
        $vankine_layout =   $page_layouts;
    elseif(is_404()):
        $vankine_layout = 'no-sidebar';
        
    elseif(is_tax('service_category')  || is_singular('service')):
        $vankine_layout =  $service_layouts;
 
    elseif(is_tax('portfolio_category')  || is_singular('portfolio')):
        $vankine_layout = 'no-sidebar';
    elseif(is_post_type_archive('product') || is_tax('product_cat')  || is_singular('product')):
        $vankine_layout =  $layout_shop;
    endif;
    return $vankine_layout;
}
endif;
/*
======================================
Display Columns
======================================
*/
if(!function_exists('vankine_get_content_columns')):
/*
**Get CSS classes for content columns output
**@param string $layout
**@return array
*/
function vankine_get_content_columns($vankine_layout = null){
    $vankine_layout = $vankine_layout ? $vankine_layout : vankine_get_layout();
    if('no-sidebar' == $vankine_layout):
        echo esc_html__('no_column' , 'vankine');
    else:
        echo esc_html__('col-lg-9 col-md-12 col-sm-12 col-xs-12', 'vankine');
    endif;  
   }
endif;

if(!function_exists('vankine_column_for_page')):
    function vankine_column_for_page(){
        if(is_active_sidebar('page-sidebar')):
            vankine_get_content_columns();
        elseif(!is_active_sidebar('page-sidebar')):
            echo esc_html('no_column no_sidebar', 'vankine');
        endif;
    }
endif;

if(!function_exists('vankine_column_for_service')):
    function vankine_column_for_service(){
        if(is_active_sidebar('service-sidebar')):
            vankine_get_content_columns();
        elseif(!is_active_sidebar('service-sidebar')):
            echo esc_html('no_column no_sidebar', 'vankine');
        endif;
    }
endif;



if(!function_exists('vankine_column_for_blog')):
    function vankine_column_for_blog(){
        if(is_active_sidebar('sidebar-blog')):
            vankine_get_content_columns();
        elseif(!is_active_sidebar('sidebar-blog')):
            echo esc_html('no_column', 'vankine');
        endif;
    }
endif;
   
if (!function_exists('vankine_column_for_shop')):
    function vankine_column_for_shop(){
        if(is_active_sidebar('shop-sidebar')):
            vankine_get_content_columns();
        elseif(!is_active_sidebar('shop-sidebar')):
            echo esc_html('no_column no_sidebar', 'vankine');
        endif;
    }
endif;