<?php
/*
** ============================== 
** Vankine Funtion File
** ==============================
*/
/*
** ============================== 
**  vankine_common_query
** ============================== 
*/
if(!function_exists('vankine_common_query')):
    function vankine_common_query($post_type){
        $post_list = get_posts(array(
            'post_type' => $post_type,
            'showposts' => -1,
        ));
        $posts = array();
        if (!empty($post_list) && !is_wp_error($post_list)) {
            foreach ($post_list as $post) {
                $options[$post->ID] = $post->post_title;
            }
            return $options;
        }
    }
endif; 
/* Check if Elementor is active.*/

/*
=============================================================
Search popup
=============================================================
*/
add_action('vankine_get_search_popup' , 'vankine_search_popup');
function vankine_search_popup() { ?>
    <div class="search-popup">
      <div class="close-search zoom-in-zoom-out"><i class="fa fa-times"></i></div>
          <div class="popup-inner">
              <div class="overlay-layer"></div>
                  <div class="search-form">
                      <fieldset>
                          <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
                              <input type="search" class="search" placeholder="<?php echo esc_attr__( 'Search...', 'vankine' ); ?>" value="<?php echo get_search_query() ?>" name="s" title="Search" />
                              <button type="submit" class="sch_btn"> <i class="fi-rs-search"></i></button>
                          </form>
                      </fieldset>
                  </div>
              </div>
          </div>
   <?php
  }
 
/*
=========================
vankine back to top
========================
*/
function vankine_back_to_top(){
    global $vankine_theme_mod;
    if(!empty($vankine_theme_mod['bactotop_enable']) == true){
?>
    <!-- Back to top with progress indicator-->
    <div class="prgoress_indicator">
      <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
      </svg>
    </div>
<?php
}}
add_action('get_vankine_back_to_top', 'vankine_back_to_top');


/*
=========================
Vankine preloader
========================
*/
function vankine_preloaders(){
    global $vankine_theme_mod;
    $preloaderimage = '';
    if(!empty($vankine_theme_mod['preloader_image']['url'])){
        $preloaderimage = $vankine_theme_mod['preloader_image']['url'];
    }
    $preloader_get_img  = $preloaderimage;
    if(get_post_meta(get_the_ID() , 'preloader_custom_enable', true)){
        $preloader_get_img = get_post_meta(get_the_ID() , 'preloader_image', true);
        $preloader_get_img = $preloader_get_img ? wp_get_attachment_image_src($preloader_get_img, 'full') : wp_get_attachment_image_url(get_the_ID() , 'full'); 
        $preloader_get_img = $preloader_get_img[0];
    }
    $preloader_mg_get = $preloader_get_img ? 'background-image:url(' . $preloader_get_img . ')!important; ' : '';
    $get_pre_style  = "style= $preloader_mg_get ";
    ?>
    <div class="loader-wrap">
        <div class="preloader" <?php echo esc_attr($get_pre_style); ?>>
            <div class="preloader-close"><i class="fi-rr-cross"></i></div>
        </div>
        <div class="layer"> </div>      
        <?php if(empty($vankine_theme_mod['preloader_image']['url'])): ?>
        <div class="animation-preloader"> 
            <div class="spinner"></div>
        </div>
        <?php endif; ?>
    </div>
    <?php  
}
add_action('vankine_get_preloaders', 'vankine_preloaders');

/*
=========================
Vankine order Line
========================
*/
function vankine_border_line(){
 ?>
<div class="line_box_outer">
	<div class="lined"></div>
	<div class="lined two"></div>
	<div class="lined three"></div>
	<div class="lined four"></div>
	<div class="lined"></div>
</div>
<?php  
}
add_action('vankine_get_border_line', 'vankine_border_line');