<?php
/*
** ============================== 
** vankine Admin Panel
** ==============================
*/
add_action( 'admin_menu', 'vankine_plugin_menu' );
function vankine_plugin_menu() {
	add_menu_page( 
        'Vankine',
        'Vankine',
        'manage_options',
        'vankine', 
        'vankine_settings_page',
        'dashicons-admin-settings', // Icon
        2 
    );
    
    add_submenu_page(
        'vankine', // Parent slug (replace with the slug of the parent menu item)
        'Vankine Settings', // Page title
        'About Vankine', // Menu title
        'manage_options', // Capability required to access the page
        'vankine', // Menu slug
        'vankine_settings_page', // Callback function to display content
        0
    );
}

// Callback function for top-level menu item
function vankine_settings_page() {
// Add HTML for navigation tabs
global $wp_filesystem, $wpdb;
?>
<section class="vankine_tab_box">

    <div class="vankine_tab_wrapper">
        <div class="vankine_admin_tab">
            <div class="vankine_content_box">

                <div class="welcome_contnet c_bg_color">
                    <h2 class="main_t"><?php echo esc_html('Welcome to Vankine ---> ' , 'vankine'); ?> <?php $current_theme = wp_get_theme();
                    echo 'Current theme version: ' . $current_theme->get( 'Version' );
                ?></h2>
                    <p class="end">
                        <?php echo esc_html('Thank you for purchasing our Vankine theme. Here you are able to 
                        start creating your awesome web Application by importing our dummy content and theme by options.' , 'vankine'); ?>
                    </p>
                    <div class="clearfix d-flex">
                        <div class="copt_system_information  c_bg_teo_color">
                            <h2>
                                <?php echo esc_html('System Information' , 'vankine'); ?>
                            </h2>
                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('Your Php Version ' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php $php_version = phpversion();
                                            if (version_compare($php_version, '5.6', '<')):
                                            ?>
                                        <?php echo esc_attr($php_version); echo esc_html__(' is too old. Please upgrade to version 5.6 or higher' , 'vankine'); ?>
                                        <label> <?php esc_html__('Please contact Host provider to fix it.','vankine') ?>
                                        </label>
                                        <?php else: ?>
                                        <?php  echo esc_attr($php_version); echo esc_html__(' is up to date.' , 'vankine'); ?>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                            </div>
                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('MySQL Version' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php  
                                             global $wpdb;
                                             $mysql_version = $wpdb->get_var("SELECT version() as version");
                                            ?>
                                        <span><?php echo esc_attr($mysql_version); ?></span>

                                    </li>
                                </ul>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('PHP Post Max Size' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php  
                                            $max_post_size_bytes = wp_convert_hr_to_bytes( ini_get( 'post_max_size' ) );
                                            $max_post_size_formatted = size_format( $max_post_size_bytes );
                                            $bytes = wp_convert_hr_to_bytes( '512MB' );
                                            ?>
                                        <span><?php echo esc_attr($max_post_size_formatted); ?></span>
                                        <small><?php if($max_post_size_bytes >  $bytes): ?>
                                            <?php echo esc_html('looks good' , 'vankine'); ?>
                                            <?php else: ?>
                                            <?php echo esc_html('Increase Your Post Max Size greaten than 512' , 'vankine'); ?>
                                            <?php endif; ?>
                                        </small>
                                    </li>
                                </ul>
                            </div>
                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('Max Upload Size' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php $max_upload_size_low = 128;
                                            $max_upload_size = ini_get('upload_max_filesize'); ?>
                                        <span><?php echo esc_attr($max_upload_size); ?></span>
                                        <small>
                                            <?php echo esc_html('looks good' , 'vankine'); ?>
                                        </small>
                                    </li>
                                </ul>
                                <?php if($max_upload_size < $max_upload_size_low): ?>
                                <em> <?php echo esc_html('Increase Max Upload Size to 300 or 512 or maximum' , 'vankine'); ?>
                                </em>
                                <?php endif; ?>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('PHP Time Limit' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php $current_time_limit = ini_get('max_execution_time'); ?>
                                        <?php if ($current_time_limit < 1000): ?>
                                        <span>
                                            <?php echo esc_attr($current_time_limit); echo esc_html__('sec' , 'vankine'); ?></span>
                                        <?php else: ?>
                                        <span>
                                            <?php echo esc_attr($current_time_limit); echo esc_html__(' sec' , 'vankine'); ?>
                                            <small>
                                                <?php echo esc_html('looks good' , 'vankine'); ?>
                                            </small>
                                        </span>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                                <?php if ($current_time_limit < 1000): ?>
                                <em><?php echo esc_html('Your PHP time limit is too low. Please set it to at least 1000 seconds to import demo content' , 'vankine'); ?>
                                </em>
                                <?php endif; ?>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('PHP Max Input Vars' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php
                                        $max_input_vars = ini_get('max_input_vars');
                                        $menu_items = get_nav_menu_locations();
                                        $menu_items_count = count($menu_items);
                                        $required_input_vars = ceil(($menu_items_count * 4) / 1024);
                                        $buffer = 500; // adjust this as needed
                                        $required_input_vars += $buffer;
                                        $required_input_vars_formatted = number_format($required_input_vars);
                                        $current_input_vars_formatted = number_format($max_input_vars);
                                        ?>
                                        <span><?php echo esc_attr($current_input_vars_formatted); ?> </span> <small>
                                            <?php echo esc_html('looks good' , 'vankine'); ?>
                                        </small>

                                    </li>
                                </ul>
                                <?php if ($max_input_vars < $required_input_vars): ?>
                                <em><strong><?php echo esc_html('Note:' , 'vankine'); ?></strong>
                                    <?php echo esc_html('Your current PHP Max Input Vars setting is too low. Please increase it to at least', 'vankine'); ?>
                                    <?php echo esc_attr($required_input_vars_formatted); ?><?php echo esc_html(' to avoid issues with your menu items.', 'vankine'); ?></em>
                                <?php endif; ?>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('ZipArchive' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php if(class_exists('ZipArchive')): ?>
                                        <span><?php echo esc_html('Yes' , 'vankine'); ?></span>
                                        <?php else: ?>
                                        <?php echo esc_html('No' , 'vankine'); ?>
                                        <?php endif; ?>

                                    </li>
                                </ul>
                                <?php  if (!class_exists('ZipArchive')): ?>
                                <em><?php echo esc_html('ZipArchive class is not available on your server.' , 'vankine'); ?></em>
                                <?php endif; ?>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('GD Library' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php if (extension_loaded('gd') && function_exists('gd_info')): ?>
                                        <span><?php $gdinfo = gd_info();
				                                echo esc_html($gdinfo['GD Version']); ?></span>
                                        <?php else: ?>
                                        <span><?php echo esc_html__('Not Installed', 'vankine'); ?></span>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                            </div>

                            <div class="inform">
                                <ul>
                                    <li class="heads">
                                        <?php echo esc_html('cURL' , 'vankine'); ?>
                                    </li>
                                    <li>
                                        =>
                                    </li>
                                    <li>
                                        <?php if (function_exists('curl_version')): ?>
                                        <span><?php    $curl_version = curl_version();
                                            echo esc_html($curl_version['version']); ?></span>

                                        <?php else: ?>
                                        <span><?php echo esc_html('Not Enabled' , 'vankine'); ?></span>
                                        <?php endif; ?>

                                    </li>
                                </ul>
                            </div>

                        </div>
                        <div class="right_box">
                            <div class="d-flex">
                                <div class="documentation common_box">
                                    <div class="inner_docsuppo">
                                        <h6><?php echo esc_html__('Our documentation is simple  , With details and covers all the essential features from the beginning to the most advanced.' , 'vankine') ?>
                                            <br>
                                            <a href="https://themepanthers.com/wp/vankine/demos/documentation/"
                                                target="_blank">
                                                <?php echo esc_html('Click  here to check Documentation' , 'vankine'); ?>
                                            </a></h6>
                                        <?php  $docsimg = get_template_directory_uri() . '/includes/admin/images/documentation.jpg'; ?>
                                        <?php if(!empty($docsimg)): ?><img class="img-fluid"
                                            src="<?php echo esc_attr($docsimg); ?>"
                                            alt="documentation" /><?php endif; ?>
                                    </div>

                                </div>
                                <div class="support common_box">
                                    <div class="inner_docsuppo">
                                        <h6> <?php echo esc_html__('Vankine theme comes with 6 months of free support for every license you purchase. Support can be extended through subscriptions via ThemeForest.' , 'vankine') ?>
                                            <br>
                                            <a href="https://steelthemes.ticksy.com/submit/#100021264" target="_blank">
                                                <?php echo esc_html('Click here to get Support' , 'vankine'); ?>
                                            </a>
                                        </h6>
                                        <?php  $support = get_template_directory_uri() . '/includes/admin/images/support.jpg'; ?>
                                        <?php if(!empty($support)): ?><img class="img-fluid"
                                            src="<?php echo esc_attr($support); ?>" alt="support" /><?php endif; ?>
                                    </div>
                                </div>

                            </div>

                            <div class="d-flex"> 
                                <div class="video common_box">
                                    <div class="inner_docsuppo">
                                        <h6> <?php echo esc_html__('Here is the Video Tutorials to install theme , pluign , import demo content and Get Start with it.' , 'vankine') ?>
                                            <br>
                                            <a href="https://www.youtube.com/watch?v=O-IeyBzJVBw&list=PL0r7c9VEks_sTJq58-Fyze5j6FSEslI18" target="_blank">
                                                <?php echo esc_html('Click here to get Video Tutorials' , 'vankine'); ?>
                                            </a>
                                        </h6>
                                        <?php  $support = get_template_directory_uri() . '/includes/admin/images/support.jpg'; ?>
                                        <?php if(!empty($support)): ?><img class="img-fluid"
                                            src="<?php echo esc_attr($support); ?>" alt="support" /><?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="our_recent_themes">
                                <h2><?php echo esc_html('Our Recent Themes' , 'vankine'); ?> </h2>

                                <div class="d-flex">


                                    <div class="video common_box">
                                        <div class="inner_docsuppo">
                                            <?php  $theme_1 = get_template_directory_uri() . '/includes/admin/images/theme-1.jpg'; ?>
                                            <?php if(!empty($theme_1)): ?><img class="img-fluid"
                                                src="<?php echo esc_attr($theme_1); ?>" alt="support" /><?php endif; ?>
                                            <h6>
                                                <?php echo esc_html('CopyGen - AI Writer & Copywriting WordPress Theme' , 'vankine'); ?>
                                                <a href="https://themeforest.net/item/vankine-insurance-business-wordpress-theme/43132301" target="_blank">
                                                    <?php echo esc_html('Purchase Now' , 'vankine'); ?>
                                                </a>
                                            </h6>
                                        </div>
                                    </div>


                                    <div class="video common_box">
                                        <div class="inner_docsuppo">
                                            <?php  $theme_2 = get_template_directory_uri() . '/includes/admin/images/theme-2.jpg'; ?>
                                            <?php if(!empty($theme_2)): ?><img class="img-fluid"
                                                src="<?php echo esc_attr($theme_2); ?>" alt="support" /><?php endif; ?>
                                            <h6>
                                                <?php echo esc_html('Creote - Corporate & Consulting Business WordPress Theme' , 'vankine'); ?>
                                                <a href="https://themeforest.net/item/creote-business-wordpress-theme/34450141" target="_blank">
                                                    <?php echo esc_html('Purchase Now' , 'vankine'); ?>
                                                </a>
                                            </h6>
                                        </div>
                                    </div>

                                    <div class="video common_box">
                                        <div class="inner_docsuppo">
                                            <?php  $theme_3 = get_template_directory_uri() . '/includes/admin/images/theme-3.jpg'; ?>
                                            <?php if(!empty($theme_3)): ?><img class="img-fluid"
                                                src="<?php echo esc_attr($theme_3); ?>" alt="support" /><?php endif; ?>
                                            <h6>
                                                <?php echo esc_html('Lawnella - Gardening & Landscaping WordPress Theme' , 'vankine'); ?>
                                                <a href="https://themeforest.net/item/lawnella-landscaping-wordpress-theme/26526840" target="_blank">
                                                    <?php echo esc_html('Purchase Now' , 'vankine'); ?>
                                                </a>
                                            </h6>
                                        </div>
                                    </div>

                                    <div class="video common_box">
                                        <div class="inner_docsuppo">
                                            <?php  $theme_4 = get_template_directory_uri() . '/includes/admin/images/theme-4.jpg'; ?>
                                            <?php if(!empty($theme_4)): ?><img class="img-fluid"
                                                src="<?php echo esc_attr($theme_4); ?>" alt="support" /><?php endif; ?>
                                            <h6>
                                                <?php echo esc_html('Nest - Grocery Store WooCommerce WordPress Theme' , 'vankine'); ?>
                                                <a href="https://themeforest.net/item/nest-multipurpose-woocommerce-wordpress-theme/37772027" target="_blank">
                                                    <?php echo esc_html('Purchase Now' , 'vankine'); ?>
                                                </a>
                                            </h6>
                                        </div>
                                    </div>

                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>
<?php
}

  
// Add JavaScript to show/hide tab content
add_action( 'admin_enqueue_scripts', 'vankine_admin_scripts' );
function vankine_admin_scripts() {
    wp_enqueue_style('vankine-admin-style', get_template_directory_uri() . '/includes/admin/css/style.css', array() , '1.0.0', 'all'); 
	wp_enqueue_script( 'vankine-admin',  get_template_directory_uri() . '/includes/admin/js/admin.js', array( 'jquery' ), '1.0', true );
}

// get admin Notice 
function display_admin_notice() {
    global $vankine_theme_mod;
    $admin_notice_enable = isset( $vankine_theme_mod['admin_notice_enable'] ) ? $vankine_theme_mod['admin_notice_enable'] : ''; 
    $admin_dashboard_url = admin_url('admin.php?page=vankine-settings'); 
    ?>
   <div class="admin-notice admin-notice-vankines notice notice-info is-dismissible <?php if($admin_notice_enable == false): ?> disable_copt_notice <?php  endif; ?>">
    <ul>
        <li><?php echo esc_html('Before Import Demo Content Check the server configuration here' , 'vankine'); ?> <a target="_blank" href="<?php echo esc_url($admin_dashboard_url);?>"><?php echo esc_html('Click here...' , 'vankine'); ?></a></li>
        <li><?php echo esc_html('We are here to help you.For any issues please submit your ticket here' , 'vankine'); ?> <a target="_blank" href="https://steelthemes.ticksy.com/submit/#100020921"><?php echo esc_html('Get Support' , 'vankine'); ?></a></li>
        <li><?php echo esc_html('Looking for vankine Documentation' , 'vankine'); ?> <a target="_blank" href="https://themepanthers.com/wp/vankine/demos/documentation/"><?php echo esc_html('Click here' , 'vankine'); ?></a></li>
    </ul>
    <p><?php echo esc_html('Disable this notification totally go to Vankine -> theme option ->  general settings ->  Disable Admin Notice => Switch Off' , 'vankine'); ?></p>
    </div> 
   <?php
}
add_action( 'admin_notices', 'display_admin_notice' );


 