<?php
/*
**==============================   
**    Vankine Function File
**==============================
*/ 
// =================isMobile======================
require_once get_template_directory() . '/includes/lib/Mobile_Detect.php';
function isMobile() {
    if ( ! class_exists( 'vankine_mobile_detect' ) ) {
        return false;
    }
    $detect = new vankine_mobile_detect;
    $mobile = false;
    if( $detect->isMobile() || $detect->isTablet() ){
        $mobile = true;
    }
    return $mobile;
}
// ===================isMobile====================
// ===================theme=======================
require get_template_directory() . '/includes/functions/theme.php';
// ===================theme=======================
// ============================== theme update ============================
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;
if(class_exists('Vankine_update')):
$myUpdateChecker = PucFactory::buildUpdateChecker(
	'https://themepanthers.com/updatedplugin/vankine/theme.json',
	__FILE__, //Full path to the main plugin file or functions.php.
	'creote-theme-update'
);
endif;
// ============================== theme update ============================


add_action('admin_notices', 'custom_plugin_update_notice');

function custom_plugin_update_notice() {
    // URL to the hosted version.json file
    $json_url = 'https://themepanthers.com/updatedplugin/plugins.json';

    // Fetch the JSON file
    $response = wp_remote_get($json_url);

    // Check for errors
    if (is_wp_error($response)) {
        return; // Exit if there's an error fetching the JSON
    }

    // Parse the JSON response
    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if (!isset($data['plugins']) || !is_array($data['plugins'])) {
        return; // Exit if the JSON structure is invalid
    }

    foreach ($data['plugins'] as $plugin) {
        $plugin_path = WP_PLUGIN_DIR . '/' . $plugin['slug'] . '/' . $plugin['slug'] . '.php';

        if (file_exists($plugin_path)) {
            // Get installed plugin data
            $plugin_data = get_plugin_data($plugin_path);
            $installed_version = $plugin_data['Version'];

            // Compare versions
            if (version_compare($installed_version, $plugin['latest_version'], '<')) {
                // Installed version is outdated
                echo '<div class="notice notice-warning is-dismissible">';
                echo '<p>' . sprintf(
                    esc_html__('A new version of %s is available. Installed version: %s, Latest version: %s. You can download the update from %s.', 'risehand'),
                    '<strong>' . esc_html($plugin['name']) . '</strong>',
                    esc_html($installed_version),
                    esc_html($plugin['latest_version']),
                    '<a href="' . esc_url($plugin['source']) . '" target="_blank">' . esc_html__('here', 'risehand') . '</a>'
                ) . '</p>';
                echo '</div>';
            }
        }  
    }
}
