<?php

return array(
	'id'     => 'vankine_addons_service_settings',
	'title'  => esc_html__( "Service Settings", "vankine-addons" ),
	'fields' => array(
        array(
			'id'    => 'service_icon_type',
			'type'  => 'select',
			'title' => esc_html__( 'Choose Icon Type', 'vankine-addons' ),
			'options' => array(
				'image' =>  esc_html__('Image', 'vankine-addons'),
				'icon' => esc_html__('Icon', 'vankine-addons'), 
			) ,
            'default' => esc_html__( 'icon', 'vankine-addons' ),
		),
        array(
			'id'    => 'ser_icon',
			'type'  => 'select',
			'title' => esc_html__( 'Choose Icon', 'vankine-addons' ),
			'options' => vankine_get_icon(),
			'required' => array( 'service_icon_type', '=', 'icon' ),
		),

           
        array(
            'id'       => 'ser_icon_img',
            'type'     => 'media', 
            'url'      => true,
            'default'  => array(
                'url'=>  get_template_directory_uri().'/assets/images/icon.png', 
            ),
            'title'    => __('Icon Image', 'vankine-addons'),
            'required' => array('service_icon_type', '=', 'image'),
        ),

        array(
			'title' => esc_html__('Steps', 'vankine-addons') ,
			'id' => 'serv_steps',
			'type' => 'text',
            'default' => esc_html__( '1', 'vankine-addons' ),
		), 
     
 
	),
);

