<?php

namespace  Vankineaddons\Core\Widgets\Post;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Service_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-service-v1';
    }

    public function get_title()
    {
        return __('Service Post  V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['102'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('service_settings',
        [ 
            'label' => __('Service Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );


        $this->add_control(
            'service_style',
            [
                'label' => __('Service style', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one'   => esc_html__( 'Style One', 'vankine-addons' ),
                    'style_two'   => esc_html__( 'Style Two', 'vankine-addons' ),
                    'style_three'   => esc_html__( 'Style Three', 'vankine-addons' ), 
                    'style_four'   => esc_html__( 'Style Four', 'vankine-addons' ), 
                    'style_five' => esc_html__( 'Style Five', 'vankine-addons' ), 
                    'style_six' => esc_html__( 'Style Six', 'vankine-addons' ), 
                    'style_seven' => esc_html__( 'Style Seven', 'vankine-addons' ), 
                    'style_eight' => esc_html__( 'Style Eight', 'vankine-addons' ), 
                ],
                'default' => 'style_one',
              
            ]
        );
        $this->add_control(
            'borenable',
           [
              'label' => __('Border  Enable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
               'condition' => [
                'service_style' => 'style_six'
                ],
           ]
        );

        $this->add_control(
            'service_column',
            [
                'label' => __('Service Column', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'vankine-addons' ),
                    'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'vankine-addons' ),
                    'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'vankine-addons' ),
                    'col-xl-12'   => esc_html__( 'One Column', 'vankine-addons' ),
                ],
                'default' => 'col-xl-3 col-lg-4 col-md-6 col-sm-6',
                 
            ]
        );
        $this->add_control(
            'read_more',
            [
                'label' => __( 'Read More', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Read More', 'vankine-addons' ),
            ]
        );
        $this->add_control(
            'post_count',
            [
                'label' => __('Service Count', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
        $this->add_control(
            'text_limits',
            [
                'label'   => esc_html__( 'Text Limit', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
       
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
                    ''       => esc_html__( 'Select', 'vankine-addons' ),
					'date'       => esc_html__( 'Date', 'vankine-addons' ),
					'title'      => esc_html__( 'Title', 'vankine-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'vankine-addons' ),
					'rand'       => esc_html__( 'Random', 'vankine-addons' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
                    ''       => esc_html__( 'Select', 'vankine-addons' ),
					'DESC' => esc_html__( 'DESC', 'vankine-addons' ),
					'ASC'  => esc_html__( 'ASC', 'vankine-addons' ),
				),
			]
        );
      
        $this->add_control(
            'query_category', 
			[
            'type' => \Elementor\Controls_Manager::SELECT2,
			'label' => esc_html__('Category', 'vankine-addons'),
			'options' => vankine_get_service_categories(),
			]
        );

        $this->add_control(
            'excerpt_enable',
           [
              'label' => __('Excerpt Enable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
        $this->add_control(
            'ajax_loadmore',
           [
              'label' => __('Ajax Load More Enable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
        $this->add_control(
            'load_more',
            [
                'label' => __( 'Load More', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Load More', 'vankine-addons' ),
                'condition' => [
                    'ajax_loadmore' => 'yes'
               ],
            ]
        );
        $this->add_control(
            'pagination_enable',
           [
              'label' => __('Pagination Enable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
    
        $this->add_responsive_control(
            'pagination_alignment',
            [
                'label' => __('Pagination alignments', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                  'left' => [
                    'title' => __( 'Pagination Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                  ],
                  'center' => [
                    'title' => __( 'Pagination Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                  ],
                  'right' => [
                    'title' => __( 'Pagination Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                  ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                  '{{WRAPPER}} .pagination_blog ' => 'text-align: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes'
               ],
            ]
        );


        $this->add_control(
			'hrp',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'pagination_enable' => 'yes'
                ],
			]
		);

        $this->add_control(
            'pagcolor',
            [
                'label' => __('Pagination Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li a.page-link , {{WRAPPER}}   .pagination li .page-numbers , {{WRAPPER}}  .page-numbers li a.page-link , {{WRAPPER}}  .page-numbers li .page-numbers  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagacolor',
            [
                'label' => __('Pagination Active Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li span.current , {{WRAPPER}}  .page-numbers li span.current , {{WRAPPER}}  .pagination li span:hover , {{WRAPPER}}  .page-numbers li span:hover ' => 'color: {{VALUE}}!important; text-decoration-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxticoncolor',
            [
                'label' => __('Pagination Next / Prev  Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxtpreviconcolor',
            [
                'label' => __('Pagination Next / Prev Border Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxtbgcolor',
            [
                'label' => __('Pagination Next / Prev Bg Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

       

        $this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
			]
		);
           
        $this->add_control(
            'load_more_color',
            [
                'label' => __('Load More Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'load_morebg_color',
            [
                'label' => __('Load More Bg Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'load_moreborder_color',
            [
                'label' => __('Load More Border Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'load_ho_more_color',
            [
                'label' => __('Load More Hover Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'loadho_morebg_color',
            [
                'label' => __('Load More Hover Bg Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'loadho_moreorho_color',
            [
                'label' => __('Load More Hover Border Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => ' border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
    $this->end_controls_section();

    $this->start_controls_section('custom_cssserpos',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'icon_color',
         [
            'label' => __('Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two .content_box .icon i , {{WRAPPER}} .service_box.type_one .content_box .content_inner .icon i ,
                {{WRAPPER}} .service_box.type_three .content_box .content_box_in .icon i , {{WRAPPER}} .service_box.type_four .icon i , {{WRAPPER}} .service_box.type_five .icon i ,
                {{WRAPPER}} .service_box.type_six .d-flex.trans .icon i , {{WRAPPER}}  .service_box.type_seven .icon i , {{WRAPPER}} .service_box.type_eight .content .icon i
                ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'icon_bg_color',
         [
            'label' => __('Icon Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two .content_box .icon  , {{WRAPPER}} .service_box.type_five  .icon  ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_two' , 'style_four'] ,
            ],
         ]
    );
    $this->add_control(
        'icon_bgsv_color',
         [
            'label' => __('Icon Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_seven .icon svg path  ' => 'fill: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_seven'] ,
            ],
         ]
    );
    
    $this->add_control(
        'icon_ho_bg_color',
         [
            'label' => __('Icon Hover Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two:hover .content_box .icon , {{WRAPPER}} .service_box.type_two:hover .img_bx   ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_two'] ,
           ],
         ]
    );
    $this->add_control(
        'icon_hosvbg_color',
         [
            'label' => __('Icon Hover Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_seven:hover .icon svg path ' => 'fill: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_seven'] ,
           ],
         ]
    );
    $this->add_control(
        'icon_ho_color',
         [
            'label' => __('Icon Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two:hover .content_box .icon i  , {{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .icon i , {{WRAPPER}} .service_box.type_four:hover .icon i , {{WRAPPER}}  .service_box.type_seven:hover .icon i ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_four' , 'style_seven'] ,
           ],
         ]
    );
    
    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .service_box .title_24 a , {{WRAPPER}}  .service_box .title_22 a , {{WRAPPER}} .service_box .title_26 a ,  {{WRAPPER}} .service_box span:after ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'title_hover_color',
         [
            'label' => __('Title Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .service_box:hover .title_24 a  , {{WRAPPER}}  .service_box:hover .title_22 a , {{WRAPPER}} .service_box:hover .title_26 a  , {{WRAPPER}}   .service_box:hover span:after' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'desc_color',
         [
            'label' => __('Content Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box p , {{WRAPPER}} .service_box.type_four p  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'desc_hover_color',
         [
            'label' => __('Content Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner p , {{WRAPPER}} .service_box.type_three:hover .content_box .content_box_in p  
                , {{WRAPPER}} .service_box.type_four:hover p , {{WRAPPER}} .service_box.type_seven:hover p ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_three' , 'style_four' , 'style_seven']
            ],
         ]
    );
    $this->add_control(
        'link_color',
         [
            'label' => __('Link Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .rd_more , {{WRAPPER}} .rd_more  i , {{WRAPPER}} .service_box.type_three .content_box .content_box_in a.rd_more  , {{WRAPPER}} .service_box.type_six .content a.theme_btn ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_one .content_box .content_inner .rd_more svg path  , {{WRAPPER}} .service_box.type_five  .rd_more svg path ' => 'stroke: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_three .content_box .content_box_in a.rd_more  ' => ' text-decoration-color: {{VALUE}}!important;',
                '{{WRAPPER}}  a.rd_more svg path  ' => ' fill: {{VALUE}}!important;',      
                '{{WRAPPER}} .service_box.type_six .content a.theme_btn svg path ' => ' fill: {{VALUE}}!important; stroke: {{VALUE}}!important; ',
                '{{WRAPPER}} .service_box.type_seven .content svg path ,  {{WRAPPER}} .service_box.type_eight .content .link  svg path ' => ' fill: {{VALUE}}!important; stroke: unset!important;',         
               ],
         ]
    );
    $this->add_control(
        'link_gb_color',
         [
            'label' => __('Link Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .service_box.type_eight .content .link ' => ' background: {{VALUE}}!important;',         
            ],
            'condition' => [
                'service_style' => ['style_eight'] ,
           ],
         ]
    );
    $this->add_control(
        'link_border_color',
         [
            'label' => __('Link Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_six .content a.theme_btn , {{WRAPPER}} .service_box.type_eight .content .link ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_seven .content .left:before  ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_six'  , 'style_seven' , 'style_eight'] ,
           ],
         ]
    );
   
    $this->add_control(
        'bgh4',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'service_style' => ['style_six'] ,
           ],
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'button_bg',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .service_box.type_six .content a.theme_btn ',
            'condition' => [
                'service_style' => ['style_six'] ,
           ],
        ]
    );
   
    $this->add_control(
        'bgh5',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'service_style' => ['style_six'] ,
           ],
        ]
    );


    $this->add_control(
        'link_hover_color',
         [
            'label' => __('Link Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box .rd_more:hover , {{WRAPPER}} .service_box .rd_more:hover i ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_six .content a.theme_btn:hover ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .rd_more svg path' => 'stroke: {{VALUE}}!important;', 
                '{{WRAPPER}} .service_box.type_four:hover a.rd_more svg path  ' => ' fill: {{VALUE}}!important;',    
                '{{WRAPPER}} .service_box.type_six .content a.theme_btn:hover svg path ' => ' fill: {{VALUE}}!important; stroke: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_seven:hover .content svg path  ' => ' fill: {{VALUE}}!important; stroke: unset!important;',     
            ],
            'condition' => [
                'service_style' => ['style_two' , 'style_four' , 'style_six' , 'style_seven'] ,
           ],
         ]
    );
    $this->add_control(
        'link_two_hover_color',
         [
            'label' => __('Link Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_three:hover .content_box .content_box_in a.rd_more , {{WRAPPER}} .service_box.type_three:hover .content_box .content_box_in a.rd_more i ' => 'color: {{VALUE}}!important; text-decoration-color: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .rd_more , {{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .rd_more svg path ' => 'color: {{VALUE}}!important; stroke: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_three' , 'style_one'] ,
           ],
         ]
    );
    $this->add_control(
        'link_hover_bor_color',
         [
            'label' => __('Link Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_six .content a.theme_btn:hover  ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_seven:hover .content .left:before  ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_six' , 'style_seven'] ,
           ],
         ]
    );
   

    $this->add_control(
        'bgh1',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'service_style' => ['style_six'] ,
           ],
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'button_ho_bg',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .service_box.type_six .content a.theme_btn:hover ',
            'condition' => [
                'service_style' => ['style_six'] ,
           ],
        ]
    );
    $this->add_control(
        'bgh2',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'service_style' => ['style_six'] ,
           ],
        ]
    );

    $this->add_control(
        'overlay_color',
         [
            'label' => __('Overlay Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .hover_1 .oh , {{WRAPPER}} .service_box.type_one .content_box .content_inner:before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_three' , 'style_six' , 'style_eight'] ,
           ],
         ]
    );
   
    $this->add_control(
        'box_bg_color',
         [
            'label' => __('Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two , {{WRAPPER}} .service_box.type_one .content_box .content_inner , {{WRAPPER}} .service_box.type_three .content_box .content_box_in
               , {{WRAPPER}} .service_box.type_four  , {{WRAPPER}} .icon_box_only.type_three .icon_inner ,  {{WRAPPER}} .service_box.type_six , {{WRAPPER}}  .service_box.type_seven .content , {{WRAPPER}}  .service_box.type_eight  
                ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two'  , 'style_three' , 'style_four' , 'style_five'  , 'style_six'   , 'style_eight'] ,
           ],
         ]
    );
    $this->add_control(
        'box_bor_color',
         [
            'label' => __('Box Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_six ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_six'],
                'borenable' => 'yes', 
            ],
         ]
    );
    $this->add_control(
        'boxhoverbor_color',
         [
            'label' => __('Box Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one .content_box .content_inner ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one'],
            ],
         ]
    );
    $this->add_control(
        'boxonebor_color',
         [
            'label' => __('Hover Box Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one'],
            ],
         ]
    );
   
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'ser_bg_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .service_box.type_seven .content ',
            'condition' => [
                'service_style' => ['style_seven'] ,
           ],
        ]
    );

    $this->add_control(
        'bgseveb',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'service_style' => ['style_seven'] ,
           ],
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'ser_bgext_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .service_box.type_seven .content::before ',
            'condition' => [
                'service_style' => ['style_seven'] ,
           ],
        ]
    );
   

    $this->add_control(
        'hobox_bg_color',
         [
            'label' => __('Hover Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_three:hover .content_box .content_box_in , {{WRAPPER}} .service_box.type_four.hover_1 .oh , {{WRAPPER}} .service_box.type_seven .content::before' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_three' , 'style_four'] ,
           ],
         ]
    );
   
    $this->add_control(
        'other_content_color',
         [
            'label' => __('Other Content Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_two .img_bx ' => 'background: {{VALUE}}!important;',
                '{{WRAPPER}} .service_box.type_two .content_box .steps , {{WRAPPER}} .service_box.type_one .content_box .content_inner .steps , 
                {{WRAPPER}} .service_box.type_four .steps ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_two' , 'style_four'] ,
           ],
         ]
    );
    $this->add_control(
        'border_color',
         [
            'label' => __('Border Line Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_four .line_box .line , {{WRAPPER}} .service_box.type_five:before ' => 'background: {{VALUE}}',
            ],
            'condition' => [
                'service_style' => ['style_four' , 'style_five'] ,
           ],
         ]
    );

    $this->add_control(
        'border_hover_color',
         [
            'label' => __('Border Hover Line Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_four:hover .line_box .line ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_four'] ,
           ],
         ]
    );
    $this->add_control(
        'border_thover_color',
         [
            'label' => __('Border Hover Line Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_five:hover:before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_five'] ,
           ],
         ]
    );
    $this->add_control(
        'other_content_ho_color',
         [
            'label' => __('Other Content Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service_box.type_one:hover .content_box .content_inner .steps , {{WRAPPER}} .service_box.type_three .content_box .content_box_in .steps ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'service_style' => ['style_one' , 'style_three'],
            ],
         ]
    );

    
   
   
$this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
<section
    class="service_post position-relative <?php if($settings['ajax_loadmore'] == 'yes'): ?> ajax_service_enabled <?php endif; ?>">
    <div class="row ajaxservicecontainer">
        <?php if ( get_query_var( 'paged' ) ) { 
                $paged = get_query_var( 'paged' ); 
              } elseif ( get_query_var( 'page' ) ) { 
                $paged = get_query_var( 'page' ); 
              } else { 
                $paged = 1; 
              }
                  $query_args = array(
                        'post_type' => 'service',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'date',
                        'paged'  => $paged,
                        'posts_per_page' => $settings['post_count'],
                        'orderby'        => $settings['query_orderby'],
                        'order'          =>  $settings['query_order'],
                    );
                    if($settings['query_category'] ) $query_args['service_category'] = $settings['query_category'];
                     
                        $service_query = new \WP_Query( $query_args );
                    ?>
        <?php if($service_query->have_posts()):
                        while($service_query->have_posts()) : $service_query->the_post();
                        global $post;
                        $featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
                        $service_icon_type = get_post_meta(get_the_ID() , 'service_icon_type', true);
                        $ser_icon = get_post_meta(get_the_ID() , 'ser_icon', true);
                        $ser_icon_img = get_post_meta(get_the_ID() , 'ser_icon_img', true);
                        $serv_steps = get_post_meta(get_the_ID() , 'serv_steps', true);
                        // while loop start ?>
        <?php // servie style ?>
        <?php if($settings['service_style'] == 'style_one'): ?>
        <?php // servie style ?>
        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
            <div class="service_box type_one">
                <?php if(has_post_thumbnail()): ?>
                <a href="<?php echo esc_url(get_permalink()); ?>">
                    <div class="image">
                        <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>"
                            alt="<?php the_title(); ?>" />
                    </div>
                </a>
                <?php endif; ?>
                <div class="content_box">
                    <div class="content_inner trans">
                        <?php if($service_icon_type == 'image'): ?>
                        <?php if(!empty($ser_icon_img['url'])): ?>
                        <div class="icon trans">
                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                        </div>
                        <?php endif; ?>
                        <?php elseif($service_icon_type == 'icon'): ?>
                        <div class="icon trans">
                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                        </div>
                        <?php endif; ?>
                        <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                        <h4 class="title_24 trans">
                            <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                        </h4>
                        <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                        <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                        <p class="trans">
                            <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                        </p>
                        <?php endif; ?>
                        <?php endif; ?>
                        <a href="<?php echo esc_url(get_permalink()); ?>" class="rd_more trans">
                            <?php echo esc_attr($settings['read_more']); ?>
                            <svg width="14" height="12" viewBox="0 0 14 12" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M8 1L13 6M13 6L8 11M13 6H1" stroke="var(--color-white)" stroke-width="1.5"
                                    stroke-linecap="round" stroke-linejoin="round" />
                            </svg>

                        </a>
                    </div>
                </div>
            </div>
        </div>
        <?php // servie style ?>
        <?php elseif($settings['service_style'] == 'style_two'): ?>
        <?php // servie style ?>
        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
            <div class="service_box type_two hover_1_get">
                <?php if(has_post_thumbnail()): ?>
                <a href="<?php echo esc_url(get_permalink()); ?>" class="img_bx">
                    <div class="image trans hover_1">
                        <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>"
                            alt="<?php the_title(); ?>" />
                        <div class="oh ho_1"></div>
                        <div class="oh ho_2"></div>
                        <div class="oh ho_3"></div>
                        <div class="oh ho_4"></div>
                    </div>
                </a>
                <?php endif; ?>
                <div class="content_box trans">

                    <?php if($service_icon_type == 'image'): ?>
                    <?php if(!empty($ser_icon_img['url'])): ?>
                    <div class="icon trans">
                        <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                    </div>
                    <?php endif; ?>
                    <?php elseif($service_icon_type == 'icon'): ?>
                    <div class="icon trans">
                        <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                    </div>
                    <?php endif; ?>
                    <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                    <h4 class="title_24 trans">
                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                    </h4>
                    <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                    <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                    <p class="trans">
                        <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                    </p>
                    <?php endif; ?>
                    <?php endif; ?>
                    <a href="<?php echo esc_url(get_permalink()); ?>"
                        class="rd_more"><?php echo esc_attr($settings['read_more']); ?> <i
                            class="fi-rr-arrow-small-right"></i></a>

                </div>
            </div>
        </div>
        <?php // servie style ?>
        <?php elseif($settings['service_style'] == 'style_three'): ?>
        <?php // servie style ?>
        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
            <div class="service_box type_three hover_1_get">
                <?php if(has_post_thumbnail()): ?>
                <a href="<?php echo esc_url(get_permalink()); ?>" class="img_bx">
                    <div class="image trans hover_1">
                        <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>"
                            alt="<?php the_title(); ?>" />
                        <div class="oh ho_1"></div>
                        <div class="oh ho_2"></div>
                        <div class="oh ho_3"></div>
                        <div class="oh ho_4"></div>
                    </div>
                </a>
                <?php endif; ?>
                <div class="content_box trans">
                    <div class="content_box_in trans">
                        <?php if($service_icon_type == 'image'): ?>
                        <?php if(!empty($ser_icon_img['url'])): ?>
                        <div class="icon trans">
                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                        </div>
                        <?php endif; ?>
                        <?php elseif($service_icon_type == 'icon'): ?>
                        <div class="icon trans">
                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                        </div>
                        <?php endif; ?>
                        <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                        <h4 class="title_24 trans">
                            <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                        </h4>
                        <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                        <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                        <p class="trans">
                            <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                        </p>
                        <?php endif; ?>
                        <?php endif; ?>
                        <a href="<?php echo esc_url(get_permalink()); ?>"
                            class="rd_more"><?php echo esc_attr($settings['read_more']); ?> <i
                                class="fi-rr-arrow-small-right"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <?php // servie style ?>
        <?php elseif($settings['service_style'] == 'style_four'): ?>
        <?php // servie style ?>
        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
            <div class="service_box type_four  hover_1_get   hover_1">
                <div class="oh ho_1"></div>
                <div class="oh ho_2"></div>
                <div class="oh ho_3"></div>
                <div class="oh ho_4"></div>
                <div class="content_box trans">
                    <div class="top">
                        <?php if($service_icon_type == 'image'): ?>
                        <?php if(!empty($ser_icon_img['url'])): ?>
                        <div class="icon trans">
                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                        </div>
                        <?php endif; ?>
                        <?php elseif($service_icon_type == 'icon'): ?>
                        <div class="icon trans">
                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                        </div>
                        <?php endif; ?>
                        <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                        <h4 class="title_24 trans">
                            <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                        </h4>
                    </div>
                    <div class="line_box">
                        <div class="line"></div>
                    </div>
                    <div class="bottom">
                        <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                        <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                        <p class="trans">
                            <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                        </p>
                        <?php endif; ?>
                        <?php endif; ?>
                        <a href="<?php echo esc_url(get_permalink()); ?>" class="rd_more">
                            <svg width="21" height="21" viewBox="0 0 21 21" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M5.60161 0H19.6641C19.9128 0 20.1512 0.0987719 20.327 0.274587C20.5028 0.450403 20.6016 0.68886 20.6016 0.9375V15C20.6016 15.2486 20.5028 15.4871 20.327 15.6629C20.1512 15.8387 19.9128 15.9375 19.6641 15.9375C19.4155 15.9375 19.177 15.8387 19.0012 15.6629C18.8254 15.4871 18.7266 15.2486 18.7266 15V3.2L1.57661 20.35C1.3989 20.5156 1.16384 20.6058 0.920961 20.6015C0.678085 20.5972 0.446354 20.4988 0.274588 20.327C0.102821 20.1553 0.00443133 19.9235 0.000146059 19.6807C-0.00413921 19.4378 0.0860148 19.2027 0.251615 19.025L17.4016 1.875H5.60161C5.35297 1.875 5.11452 1.77623 4.9387 1.60041C4.76289 1.4246 4.66411 1.18614 4.66411 0.9375C4.66411 0.68886 4.76289 0.450403 4.9387 0.274587C5.11452 0.0987719 5.35297 0 5.60161 0Z"
                                    fill="white" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <?php // servie style ?>
        <?php elseif($settings['service_style'] == 'style_five'): ?>
        <?php // servie style ?>
        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
            <div class="service_box type_five icon_box_only type_three trans">
                <div class="icon_inner trans">
                    <div class="d-flex trans">
                        <?php if($service_icon_type == 'image'): ?>
                        <?php if(!empty($ser_icon_img['url'])): ?>
                        <div class="icon trans">
                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                        </div>
                        <?php endif; ?>
                        <?php elseif($service_icon_type == 'icon'): ?>
                        <div class="icon trans">
                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                        </div>
                        <?php endif; ?>
                        <div class="content">

                            <div class="title_22">
                                <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                            </div>

                            <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                            <?php $excerpt = '';
                                                if (has_excerpt()): ?>
                            <p class="trans">
                                <?php 
                                                        $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                                        echo esc_attr($excerpt);
                                                    ?>
                            </p>
                            <?php endif; ?>
                            <?php endif; ?>

                            <a href="<?php echo esc_url(get_permalink()); ?>" class="rd_more">
                                <?php echo esc_attr($settings['read_more']); ?>
                                <svg width="14" height="12" viewBox="0 0 14 12" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8 1L13 6M13 6L8 11M13 6H1" stroke="var(--color-white)" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php // servie style ?>
        <?php elseif($settings['service_style'] == 'style_six'): ?>
        <?php // servie style ?>
        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
            <div
                class="service_box type_six hover_1_get <?php if($settings['borenable']): ?>borenable<?php endif; ?>  trans">
                <div class="d-flex trans">
                    <?php if($service_icon_type == 'image'): ?>
                    <?php if(!empty($ser_icon_img['url'])): ?>
                    <div class="icon trans">
                        <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                    </div>
                    <?php endif; ?>
                    <?php elseif($service_icon_type == 'icon'): ?>
                    <div class="icon trans">
                        <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                    </div>
                    <?php endif; ?>
                    <div class="title_22">
                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                    </div>
                </div>

                <?php if(has_post_thumbnail()): ?>
                <a href="<?php echo esc_url(get_permalink()); ?>" class="img_bx">
                    <div class="image trans hover_1">
                        <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>"
                            alt="<?php the_title(); ?>" />
                        <div class="oh ho_1"></div>
                        <div class="oh ho_2"></div>
                        <div class="oh ho_3"></div>
                        <div class="oh ho_4"></div>
                    </div>
                </a>
                <?php endif; ?> 
                <div class="content">
                    <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                    <?php $excerpt = '';
                    if (has_excerpt()): ?>
                    <p class="trans">
                        <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                            echo esc_attr($excerpt);
                        ?>
                    </p>
                    <?php endif; ?>
                    <?php endif; ?> 
                    <a href="<?php echo esc_url(get_permalink()); ?>" class="theme_btn">
                        <?php echo esc_attr($settings['read_more']); ?>
                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 11L11 1L1 11ZM11 1H3.5H11ZM11 1V8.5V1Z" fill="#696E77" />
                            <path d="M1 11L11 1M11 1H3.5M11 1V8.5" stroke="#696E77" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </a>
                </div>
            </div>
        </div>

        <?php // servie style ?>
        <?php elseif($settings['service_style'] == 'style_seven'): ?>
        <?php // servie style ?>

        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
            <div class="service_box type_seven trans">

                <?php if($service_icon_type == 'image'): ?>
                <?php if(!empty($ser_icon_img['url'])): ?>
                <div class="icon trans">
                    <svg width="110" height="130" viewBox="0 0 110 130" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M0 124.009C0 127.128 2.82523 129.486 5.89443 128.928L105.894 110.746C108.272 110.314 110 108.244 110 105.827V5C110 2.23858 107.761 0 105 0H5C2.23858 0 0 2.23858 0 5V124.009Z"
                            fill="#008bf9" />
                    </svg>
                    <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                </div>
                <?php endif; ?>
                <?php elseif($service_icon_type == 'icon'): ?>
                <div class="icon trans">
                    <svg width="110" height="130" viewBox="0 0 110 130" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M0 124.009C0 127.128 2.82523 129.486 5.89443 128.928L105.894 110.746C108.272 110.314 110 108.244 110 105.827V5C110 2.23858 107.761 0 105 0H5C2.23858 0 0 2.23858 0 5V124.009Z"
                            fill="#008bf9" />
                    </svg>

                    <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                </div>
                <?php endif; ?>


                <div class="content d-flex align-items-center">
                    <?php if(has_post_thumbnail()): ?>
                    <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>"
                        alt="<?php the_title(); ?>" />
                    <?php endif; ?>
                    <div class="left">
                        <div class="title_26">
                            <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                        </div>
                        <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                        <?php $excerpt = '';
                                    if (has_excerpt()): ?>
                        <p class="trans">
                            <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                            echo esc_attr($excerpt);
                                        ?>
                        </p>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <div class="right">
                        <a href="<?php echo esc_url(get_permalink()); ?>" class="link">
                            <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M6.53522 0H22.9415C23.2315 0 23.5098 0.115234 23.7149 0.320352C23.92 0.52547 24.0352 0.803669 24.0352 1.09375V17.5C24.0352 17.7901 23.92 18.0683 23.7149 18.2734C23.5098 18.4785 23.2315 18.5937 22.9415 18.5937C22.6514 18.5937 22.3732 18.4785 22.1681 18.2734C21.963 18.0683 21.8477 17.7901 21.8477 17.5V3.73333L1.83938 23.7417C1.63205 23.9349 1.35781 24.04 1.07446 24.035C0.791099 24.03 0.520746 23.9153 0.320352 23.7149C0.119958 23.5145 0.00516988 23.2441 0.000170402 22.9608C-0.00482908 22.6774 0.100351 22.4032 0.293551 22.1958L20.3019 2.1875H6.53522C6.24514 2.1875 5.96694 2.07227 5.76182 1.86715C5.5567 1.66203 5.44147 1.38383 5.44147 1.09375C5.44147 0.803669 5.5567 0.52547 5.76182 0.320352C5.96694 0.115234 6.24514 0 6.53522 0Z"
                                    fill="url(#paint0_linear_1_403)" />
                                <defs>
                                    <linearGradient id="paint0_linear_1_403" x1="-0.34336" y1="13.9061" x2="24.0352"
                                        y2="13.9061" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#F86403" />
                                        <stop offset="1" stop-color="#D65501" />
                                    </linearGradient>
                                </defs>
                            </svg>

                        </a>
                    </div>
                </div>
            </div>
        </div>


        <?php // servie style ?>
        <?php elseif($settings['service_style'] == 'style_eight'): ?>
        <?php // servie style ?>

        <div class="<?php echo esc_attr($settings['service_column']); ?> ajax-service-wrapper">
            <div class="service_box type_eight trans hover_1_get">
                <div class="image_box hover_1">
                    <?php if(has_post_thumbnail()): ?>
                    <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>"
                        alt="<?php the_title(); ?>" />
                    <?php endif; ?>
                     
                    <div class="oh ho_1"></div>
                        <div class="oh ho_2"></div>
                        <div class="oh ho_3"></div>
                        <div class="oh ho_4"></div>
                </div>
                <div class="content">
                    <a href="<?php echo esc_url(get_permalink()); ?>" class="link">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M6.53522 0H22.9415C23.2315 0 23.5098 0.115234 23.7149 0.320352C23.92 0.52547 24.0352 0.803669 24.0352 1.09375V17.5C24.0352 17.7901 23.92 18.0683 23.7149 18.2734C23.5098 18.4785 23.2315 18.5937 22.9415 18.5937C22.6514 18.5937 22.3732 18.4785 22.1681 18.2734C21.963 18.0683 21.8477 17.7901 21.8477 17.5V3.73333L1.83938 23.7417C1.63205 23.9349 1.35781 24.04 1.07446 24.035C0.791099 24.03 0.520746 23.9153 0.320352 23.7149C0.119958 23.5145 0.00516988 23.2441 0.000170402 22.9608C-0.00482908 22.6774 0.100351 22.4032 0.293551 22.1958L20.3019 2.1875H6.53522C6.24514 2.1875 5.96694 2.07227 5.76182 1.86715C5.5567 1.66203 5.44147 1.38383 5.44147 1.09375C5.44147 0.803669 5.5567 0.52547 5.76182 0.320352C5.96694 0.115234 6.24514 0 6.53522 0Z"
                                fill="url(#paint0_linear_1_403)" />
                            <defs>
                                <linearGradient id="paint0_linear_1_403" x1="-0.34336" y1="13.9061" x2="24.0352"
                                    y2="13.9061" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#fff" />
                                    <stop offset="1" stop-color="#fff" />
                                </linearGradient>
                            </defs>
                        </svg>
                    </a>

                    <?php if($service_icon_type == 'image'): ?>
                    <?php if(!empty($ser_icon_img['url'])): ?>
                    <div class="icon trans">
                        <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                    </div>
                    <?php endif; ?>
                    <?php elseif($service_icon_type == 'icon'): ?>
                    <div class="icon trans">
                        <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                    </div>
                    <?php endif; ?>

                    <div class="title_22">
                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                    </div>
                    <?php if($settings['excerpt_enable'] == 'yes'):  ?>
                    <?php $excerpt = '';
                                    if (has_excerpt()): ?>
                    <p class="trans">
                        <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                            echo esc_attr($excerpt);
                                        ?>
                    </p>
                    <?php endif; ?>
                    <?php endif; ?>


                </div>
            </div>
        </div>

        <?php // servie style ?>
        <?php endif; ?>
        <?php // servie style ?>

        <?php endwhile; // while loop end ?>
        <?php wp_reset_postdata(); ?>
        <?php endif; // Post Endif after loop end  ?>
    </div>
    <!--End tab-content-->
    <?php if($settings['pagination_enable'] == 'yes' || $settings['ajax_loadmore'] == 'yes'):?>
    <div class="row">
        <div class="col-lg-12">
            <div class="pagination-area pagination">

                <?php
            if($settings['ajax_loadmore'] == 'yes'):
                $prev = '';
                $next = '<span class="theme_btn">'.$settings['load_more'].'</span>';
                $type = 'plain';
            elseif($settings['pagination_enable'] == 'yes'):
                $prev = '<i class="fa fa-angle-left"></i>';
                $next = '<i class="fa fa-angle-right"></i>';
                $type = 'list';
            endif;
            $pagination = 999999999;
            echo paginate_links( array(
                    'base' => str_replace( $pagination, '%#%', get_pagenum_link( $pagination ) ),
                    'format' => '?paged=%#%',
                     'current' => max(0, $paged),
                    'total' => $service_query->max_num_pages,
                    'prev_text' => $prev,
                    'next_text' => $next,
                    'type'=> $type,
                    'add_args' => false
                ) );
            ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
</section>

<?php
    }
}

         