<?php

namespace  Vankineaddons\Core\Widgets\Post;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Product_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-product-shop-v1';
    }

    public function get_title()
    {
        return __('Product  V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['102'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('product_shop_v1_settings',
        [ 
            'label' => __('Product Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );  
        
        $this->add_control(
            'product_column',
            [
                'label' => __('Product Column', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-xl-2 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Six Column', 'vankine-addons' ),
                    'col-lg-1-5  col-md-4 col-sm-6'   => esc_html__( 'Five Column', 'vankine-addons' ),
                    'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'vankine-addons' ),
                    'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'vankine-addons' ),
                    'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'vankine-addons' ),
                    'col-xl-12'   => esc_html__( 'One Column', 'vankine-addons' ),
                ],
                'default' => 'col-xl-3 col-lg-4 col-md-6 col-sm-6',
                
            ]
        );
        $this->add_control(
            'post_count',
            [
                'label' => __('Post Count', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
			
				'options' => array(
                          ''  => esc_html__( 'Default', 'vankine-addons' ),
					'date'       => esc_html__( 'Date', 'vankine-addons' ),
					'title'      => esc_html__( 'Title', 'vankine-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'vankine-addons' ),
					'rand'       => esc_html__( 'Random', 'vankine-addons' ),
				),
                'default' => 'date',
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				
				'options' => array(
                    ''  => esc_html__( 'Default', 'vankine-addons' ),
					'DESC' => esc_html__( 'DESC', 'vankine-addons' ),
					'ASC'  => esc_html__( 'ASC', 'vankine-addons' ),
				),
                'default' => 'DESC',
			]
        );
        $this->add_control(
            'query_category', 
				[
                    'type' => \Elementor\Controls_Manager::SELECT2, // Use SELECT2 for multiple select
                    'label' => esc_html__('Category', 'vankine-addons'),
                    'options' =>  vankine_get_product_categories(),
                    'multiple' => true, // Enable multiple select
				]
        ); 
        $this->add_control(
            'product_options_showing',
            [
                'label'   => esc_html__( 'Products', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    ''   => esc_html__( 'Select Options', 'vankine-addons' ),
                    'featured'     => esc_html__( 'Featured', 'vankine-addons' ),
                    'best_selling' => esc_html__( 'Best Selling', 'vankine-addons' ),
                    'sale'         => esc_html__( 'On Sale', 'vankine-addons' ),
                    'outofstock'   => esc_html__( 'Out Of Stock', 'vankine-addons' ),
                    'rating'   => esc_html__( 'Top Rating', 'vankine-addons' ),
                    'instock'   => esc_html__( 'In Stock', 'vankine-addons' ),
                    'price_low_high' => esc_html__( 'Price Low to High', 'vankine-addons' ),
                    'price_high_low' => esc_html__( 'Price High to Low', 'vankine-addons' ),
                ],
                'default' => '',
                'toggle'  => false,
            ]
        );
        $this->add_control(
            'product_not_in',
            [
                'label'       => esc_html__( 'Product Not In', 'vankine-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( '' , 'vankine-addons'),
            ]
        );
        $this->add_control(
            'pagination_enables',
           [
              'label' => __('Pagination Enable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'no',
           ]
        );
    
        $this->add_responsive_control(
            'pagination_alignment',
            [
                'label' => __('Pagination alignments', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                  'left' => [
                    'title' => __( 'Pagination Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                  ],
                  'center' => [
                    'title' => __( 'Pagination Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                  ],
                  'right' => [
                    'title' => __( 'Pagination Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                  ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                  '{{WRAPPER}} .pagination_blog ' => 'text-align: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enables' => 'yes'
               ],
            ]
        );
    
 

    $this->end_controls_section();

    $this->start_controls_section('product_only_notab_css',
    [ 
        'label' => __('Product  Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );

   
    $this->add_control(
        'product_tag_color',
         [
            'label' => __('Product Category Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap .product-content-wrap .product-category a  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

 
    $this->add_control(
        'product_title_color',
         [
            'label' => __('Product Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap .product-content-wrap h2 a  , {{WRAPPER}} .product-list-small h6 a , {{WRAPPER}}  .product_style_five .product-content-wrap h5 a ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'product_rating_color',
         [
            'label' => __('Product Rating Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product_wrapper .star-rating::before  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    
    $this->add_control(
        'product_rating_active_color',
         [
            'label' => __('Product Rating Active Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product_wrapper .star-rating span::before  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'product_rating_count_color',
         [
            'label' => __('Product Rating Count Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product_wrapper .product-rate-cover .font-small ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'product_vendor_color',
         [
            'label' => __('Product Vendor Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product_wrapper .product-content-wrap .font-small.text-muted ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'product_vendor_two_color',
         [
            'label' => __('Product Vendor Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product_wrapper .product-content-wrap .font-small.text-muted a ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'product_price_color',
         [
            'label' => __('Product Price Offer Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap .product-content-wrap .product-price ins span ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );


    
    $this->add_control(
        'product_price_og_color',
         [
            'label' => __('Product Price Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}   .product_wrapper .product-price del , {{WRAPPER}}   .product_wrapper .product-price del bdi , {{WRAPPER}}   .product_wrapper .product-price del  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    
    
    $this->add_control(
        'button_colors',
         [
            'label' => __('Product Btn Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap .product-card-bottom .add-cart .add , {{WRAPPER}} .product-cart-wrap .product-card-bottom .add-cart .add span , {{WRAPPER}} .product-cart-wrap .product-card-bottom .add-cart  a::before  ,
                {{WRAPPER}} .product-cart-wrap.style_two .add_to_cart_button  ,  {{WRAPPER}}
                .product_singleized.style_one .carted .cart .single_add_to_cart_button , {{WRAPPER}} .product_singleized.style_one .carted .cart .add_to_cart_button , {{WRAPPER}} .product-cart-wrap.style_two .add_to_cart_button , {{WRAPPER}} .product-cart-wrap.style_two .add.button , {{WRAPPER}} .product-cart-wrap.product_list_type .add_to_cart_button, {{WRAPPER}} .product-cart-wrap.product_list_type .add.button ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'button_bg_color',
         [
            'label' => __('Product Btn Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap .product-card-bottom .add-cart .add , {{WRAPPER}} .product-cart-wrap .product-card-bottom .add-cart .add span ,
                {{WRAPPER}} .product-cart-wrap.style_two .add_to_cart_button ,  {{WRAPPER}}
                .product_singleized.style_one .carted .cart .single_add_to_cart_button , {{WRAPPER}} .product_singleized.style_one .carted .cart .add_to_cart_button ,  {{WRAPPER}}
				.product-cart-wrap.style_two .add_to_cart_button,  {{WRAPPER}} .product-cart-wrap.style_two .add.button,  {{WRAPPER}} .product-cart-wrap.product_list_type .add_to_cart_button,  {{WRAPPER}} .product-cart-wrap.product_list_type .add.button
                ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 


    $this->add_control(
        'progress_text_color',
         [
            'label' => __('Progress Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-content-wrap .sold  span ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'progress_bg_color',
         [
            'label' => __('Progress Bar Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

 $this->add_control(
        'progress_ac_bg_color',
         [
            'label' => __('Progress Bar Active Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress-bar ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'box_color',
         [
            'label' => __('Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap , {{WRAPPER}} .product-cart-wrap .product-img-action-wrap ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'box_border_color',
         [
            'label' => __('Box Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->add_control(
        'hover_components_color',
         [
            'label' => __('Hover Content Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap .product-action-1 li button:before , {{WRAPPER}}  .product-cart-wrap .product-action-1 li i
                , {{WRAPPER}} .product-cart-wrap .product-action-1 li small ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'hover_components_bor_color',
         [
            'label' => __('Hover Content Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap .product-action-1 li ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'hover_components_tool_color',
         [
            'label' => __('Hover Content Tooltip Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .product-cart-wrap .product-action-1 li small:before  ' => 'border-top-color: {{VALUE}}!important;',
                '{{WRAPPER}}  .product-cart-wrap .product-action-1 li small ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'hover_components_bg_color',
         [
            'label' => __('Hover Content Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .product-cart-wrap .product-img-action-wrap .product-action-1 ' => 'border-color: {{VALUE}}!important; background: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
     <section class="product_shop   position-relative">
        <div class="row">
                <?php 
                  $product_not_inside = '';
                  if(!empty($settings['product_not_in'])){
                      $product_not_inside = explode(',', $settings['product_not_in']);
                  }
                  else{
                      $product_not_inside = '0';
                  }
                  if(get_query_var('paged')){ 
                    $paged = get_query_var( 'paged' ); 
                    } elseif ( get_query_var( 'page' ) ) { 
                    $paged = get_query_var( 'page' ); 
                    } else { 
                    $paged = 1; 
                }
                $query_args = array(
                        'post_type' => 'product',
                        'ignore_sticky_posts' => true,
                        'paged'             => $paged,
                        'posts_per_page' => $settings['post_count'],
                        'orderby'        => $settings['query_orderby'],
                        'order'          =>  $settings['query_order'],
                        'post__not_in'   => $product_not_inside ,
                    );
                    if (!empty($settings['query_category']) && is_array($settings['query_category'])) {
                        $category_string = implode(',', $settings['query_category']);
                        $query_args['product_cat'] = $category_string;
                    }
               
                        if($settings['product_options_showing'] == 'outofstock'):
                            $query_args['meta_key'] = '_stock_status';
                            $query_args['meta_compare'] = '=';
                            $query_args['meta_value'] = 'outofstock';
                        elseif($settings['product_options_showing'] == 'instock'):
                            $query_args['meta_key'] = '_stock_status';
                            $query_args['meta_compare'] = '=';
                            $query_args['meta_value'] = 'instock';

                        elseif($settings['product_options_showing'] == 'best_selling'):
                            $query_args['meta_key'] = 'total_sales';
                            $query_args['orderby'] = 'meta_value_num';
                            $query_args['order']    = 'DESC';
                        elseif($settings['product_options_showing'] == 'featured'):
                            $query_args['tax_query'] = array( array(
                                'taxonomy' => 'product_visibility',
                                'field'    => 'name',
                                'terms'    => array( 'featured' ),
                                'operator' => 'IN',
                            ) 
                        );
                        elseif($settings['product_options_showing'] == 'sale'):
                            $query_args['meta_key'] = '_sale_price';
                            $query_args['meta_value'] = '0';
                            $query_args['meta_compare'] = '>=';
                        elseif($settings['product_options_showing'] == 'rating'):
                            $query_args['meta_key'] = '_wc_average_rating';
                            $query_args['orderby']  = 'meta_value_num';
                        elseif ($settings['product_options_showing'] == 'price_low_high'):
                            $query_args['meta_key'] = '_price';
                            $query_args['orderby'] = 'meta_value_num';
                            $query_args['order'] = 'ASC';
                        elseif ($settings['product_options_showing'] == 'price_high_low') :
                            $query_args['meta_key'] = '_price';
                            $query_args['orderby'] = 'meta_value_num';
                            $query_args['order'] = 'DESC';
                        endif;
                        $product_query = new \WP_Query( $query_args );
                    ?>
                    <?php 
                            while($product_query->have_posts()) : $product_query->the_post();
                            global $product;
			                global $post;
			                global $woocommerce; 
                            // while loop start ?>
                            <?php // product style ?> 
                                    <div class="<?php echo esc_attr($settings['product_column']); ?>">
                          
                                    <?php  get_template_part('woocommerce/content', 'custom-product'); ?>
                                 
                                    </div>
                            <?php // product style ?>                        
	
                    <?php endwhile; // while loop end ?>
                
   
            <?php wp_reset_postdata(); ?>
            </div>
    <!--End tab-content-->
            <?php if($settings['pagination_enables'] == 'yes'):?>
            <div class="row">
        <div class="col-lg-12">
        <div class="pagination_blog">
           
        <?php
     $pagination = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $pagination, '%#%', get_pagenum_link( $pagination ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, $paged ),
          'total' => $product_query->max_num_pages,
          'prev_text' => '<i class="fa fa-angle-left"></i>',
          'next_text' => '<i class="fa fa-angle-right"></i>',
          'type'=>'list', 
          'add_args' => false
     ) );
?>          
            </div>
            </div>     
            </div> 
            <?php endif; ?>  
     
</section>
 
        <?php
    }
}

         