<?php

namespace  Vankineaddons\Core\Widgets\Post;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Portfolio_Carousel_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-portfolio-caro-v1';
    }

    public function get_title()
    {
        return __('Portfolio  Carousel  V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['102'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('portfolio_settings',
        [ 
            'label' => __('portfolio Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );


        $this->add_control(
            'portfoliostyle',
            [
                'label' => __('portfolio style', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one'   => esc_html__( 'Style One', 'vankine-addons' ),
                    'style_two'   => esc_html__( 'Style Two', 'vankine-addons' ), 
                ],
                'default' => 'style_one',
            ]
        );
        $this->add_control(
            'read_more',
            [
                'label' => __( 'Read More', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Read More', 'vankine-addons' ),
            ]
        );
  
        $this->add_control(
            'desktop',
            [
                'label' => __('Carousel Items to Display Desktop', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '3',
            ]
        );
        $this->add_control(
            'tablet',
            [
                'label' => __('Carousel Items to Display Tablet', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '3',
            ]
        );
        $this->add_control(
            'mobile',
            [
                'label' => __('Carousel Items to Display Mobile', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 2,
                'max'     => 10,
                'step'    => 1,
                'default' => '2',
            ]
        );
        $this->add_control(
            'margin',
            [
                'label' => __('Spacing', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 30,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
    
        $this->add_control(
            'post_count',
            [
                'label' => __('portfolio Count', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
        $this->add_control(
            'text_limits',
            [
                'label'   => esc_html__( 'Text Limit', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
       
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
                    ''       => esc_html__( 'Select', 'vankine-addons' ),
					'date'       => esc_html__( 'Date', 'vankine-addons' ),
					'title'      => esc_html__( 'Title', 'vankine-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'vankine-addons' ),
					'rand'       => esc_html__( 'Random', 'vankine-addons' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
                    ''       => esc_html__( 'Select', 'vankine-addons' ),
					'DESC' => esc_html__( 'DESC', 'vankine-addons' ),
					'ASC'  => esc_html__( 'ASC', 'vankine-addons' ),
				),
			]
        );
      
        $this->add_control(
            'query_category', 
			[
            'type' => \Elementor\Controls_Manager::SELECT2,
			'label' => esc_html__('Category', 'vankine-addons'),
			'options' => vankine_get_portfolio_categories(),
			]
        );

         

    $this->end_controls_section();
    $this->start_controls_section('owl_nav_style',
    [ 
        'label' => __('Owl Nav Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'nav_display',
        [
        'label' => __('Naigation Enable / Disabel', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'nav_true' => __( 'Block', 'vankine-addons' ),
            'nav_false' => __( 'none', 'vankine-addons' ),
        ],
        'default' => __('nav_true' , 'vankine-addons'),
       
        ]
    );
 
    $this->add_control(
        'nav_style_options',
        [
        'label' => __('Nav Move Position', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'position_one' => __( 'Position One', 'vankine-addons' ),
            'position_two' => __( 'Position Two', 'vankine-addons' ),
            'position_three' => __( 'Position Three', 'vankine-addons' ),
            'position_four' => __( 'Position Four', 'vankine-addons' ),
        ],
        'default' => __('position_one' , 'vankine-addons'),
        ]
    );
    $this->add_responsive_control(
        'nav_move_count',
        [
            'label' => __('Nav Move Top', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_two' , 'position_three'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_two .owl-carousel .owl-nav , {{WRAPPER}}  .position_three .owl-carousel .owl-nav ' => 'top: {{VALUE}}px!important;',
            ],
        ]
    );
   
    $this->add_responsive_control(
        'nav_move_prev_left',
        [
            'label' => __('Prev Move Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => 'position_four',
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-prev   ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'nav_move_nest_right',
        [
            'label' => __('Prev Move Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => 'position_four',
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-next   ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );


    $this->add_control(
        'owl_nav_color',
         [
            'label' => __('Owl Nav Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels  .owl-nav i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_bg_color',
         [
            'label' => __('Owl Nav Arrow Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-prev , {{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-next ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    
    $this->add_control(
        'owl_nav_hover_color',
         [
            'label' => __('Owl Nav Hover Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels  .owl-nav .owl-prev:hover i , {{WRAPPER}} .sec_category_carousels  .owl-nav .owl-next:hover i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_hover_bg_color',
         [
            'label' => __('Owl Nav Hover Arrow Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-prev:hover , {{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-next:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 

    $this->end_controls_section();
    $this->start_controls_section('owl_dot_style',
    [ 
        'label' => __('Dot Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    

 
    $this->add_control(
        'dots_display',
        [
        'label' => __('Dots Enable / Disabel', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'dot_true' => __( 'Block', 'vankine-addons' ),
            'dot_false' => __( 'none', 'vankine-addons' ),
        ],
        'default' => 'dot_true' , 
       
        ]
    ); 

    $this->add_responsive_control(
        'dotalignment',
        [
            'label' => esc_html__( 'Alignment', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'dot_left',
        [
            'label' => __('Dot Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'left',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );

    $this->add_control(
        'dot_right',
        [
            'label' => __('Dot Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'right',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );
   

    $this->add_control(
        'dot_color',
         [
            'label' => __('Dot One Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span , {{WRAPPER}}  .slick-dots li button ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 
    $this->add_control(
        'dot_ac_color',
         [
            'label' => __('Dot One Active / Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover span , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span , {{WRAPPER}}  .slick-dots li.slick-active button ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->end_controls_section();

    
   
    $this->start_controls_section('custom_cssprot',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
            'name' => 'borderpro',
            'selector' => '{{WRAPPER}} .portfolio_box.type_one .image_box , {{WRAPPER}} .portfolio_box.type_two  ',
        ]
    );
    

    $this->add_control(
        'titles_color',
        [
            'label' => __('Title Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box.type_one .title_22 a , {{WRAPPER}} .portfolio_box.type_two .title_30  a ,  {{WRAPPER}} .portfolio_box.type_one .title_22 a span:after , {{WRAPPER}} .portfolio_box.type_two .title_30  a span:after ' => 'color: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'desc_color',
        [
            'label' => __('Description Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box.type_two .content_box p , {{WRAPPER}} .portfolio_box.type_one .content_box  p   ' => 'color: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'zoom_icon_color',
        [
            'label' => __('Zoom Icon Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box .zm_btn  ' => 'color: {{VALUE}}!important;',
            ],

        ]
    );
    $this->add_control(
        'zoom_icon_bg_color',
        [
            'label' => __('Zoom Icon Bg Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box .zm_btn  ' => 'background: {{VALUE}}!important;',
            ],

        ]
    );
    $this->add_control(
        'read_more_color',
        [
            'label' => __('Link Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box .lnk svg path ' => 'stroke: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'read_morebg_color',
        [
            'label' => __('Link Bg Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box .lnk ' => 'background: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'over_lay_color',
        [
            'label' => __('Overlay Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .portfolio_box .hover_1 .oh , {{WRAPPER}} .portfolio_box.type_two .bg ' => 'background: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'box_bg',
        [
            'label' => __('Box Bg Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box.type_one .content_box .content_box_in' =>  'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'portfoliostyle' => 'style_one', 
            ]
        ]
    );

    $this->add_control(
        'hrsvn',
        [
            'type' =>  \Elementor\Controls_Manager::DIVIDER,
        
        ]
    );
    $this->add_control(
        'portfolios_image_height',
        [
            'label' => esc_html__( 'portfolio Image Height', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 2000,
            'step' => 1,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box .image_box img ' => 'height: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_control(
        'hrsix',
        [
            'type' =>  \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'portfoliostyle' => 'style_one',
            ]
        ]
    );

    $this->add_control(
        'header_hos_color',
        [
            'label' => __('Heading Hover Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .title_22 a , {{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .title_22 a span:after  ' => 'color:{{VALUE}}!important;',
            ],
            'condition' => [
                'portfoliostyle' => 'style_one',
            ],
        ]
    );
    $this->add_control(
        'desc_ho_color',
        [
            'label' => __('Description Hover Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in p ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'portfoliostyle' => 'style_one',
            ]
        ]
    );
    $this->add_control(
        'box_hov_color',
        [
            'label' => __('Box Bg Hover Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'portfoliostyle' => 'style_one',
            ]
        ]
    );
    $this->add_control(
        'link_ho_color',
        [
            'label' => __('Link Hover Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .lnk svg path ' => 'stroke: {{VALUE}}!important;',
            ],
            'condition' => [
                'portfoliostyle' => 'style_one',
            ]
        ]
    );
    $this->add_control(
        'link_bg_ho_color',
        [
            'label' => __('Link Hove Bg Color', 'vankine-addons'),
            'type' =>  \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .lnk ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'portfoliostyle' => 'style_one',
            ]
        ]
    );

   
$this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
     <section class="portfolio_post <?php echo esc_attr($settings['portfoliostyle']); ?> position-relative <?php echo esc_attr($settings['nav_style_options']); ?> <?php echo esc_attr($settings['nav_display']); ?> <?php echo esc_attr($settings['dots_display']); ?>">
     <div class="theme_carousel owl-theme owl-carousel" data-options='{"loop": true , "margin": <?php echo esc_attr($settings['margin']); ?>, "autoheight":true, "lazyload":true, "nav": true, "dots": true, "autoplay": false, "autoplayTimeout": 6000,  "smartSpeed": 300, "responsive":{ "0" :{ "items": "1" }, "320" :{ "items" : "1" }, "500" :{ "items" : "1" }, "768" :{ "items" : "<?php echo esc_attr($settings['mobile']); ?>" } , "992":{ "items" : "<?php echo esc_attr($settings['tablet']); ?>" }, "1200":{ "items" : "<?php echo esc_attr($settings['desktop']); ?>" }}}'>
              
                <?php  
                  $query_port = array(
                        'post_type' => 'portfolio',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'date', 
                        'posts_per_page' => $settings['post_count'],
                        'orderby'        => $settings['query_orderby'],
                        'order'          =>  $settings['query_order'],
                    );
                    if($settings['query_category'] ) $query_port['portfolio_category'] = $settings['query_category'];
                     
                        $portfolio_query = new \WP_Query( $query_port );
                    ?>
                    <?php if($portfolio_query->have_posts()):
                    while($portfolio_query->have_posts()) : $portfolio_query->the_post();
                    // while loop start ?>
                    <?php // portfolio style ?>
					    <?php if($settings['portfoliostyle'] == 'style_one'): ?>
                    <?php // portfolio style ?>    
                       
                    <div class="portfolio_box type_one hover_1_get">
                        <div class="image_box hover_1">
                            <?php the_post_thumbnail(); ?>
                            <a data-fancybox="gallery" class="zm_btn trans"
                                href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>">
                                <span class="fi-rs-cursor-plus zoom_icon"></span>
                            </a>
                            <div class="oh ho_1"></div>
                            <div class="oh ho_2"></div>
                            <div class="oh ho_3"></div>
                            <div class="oh ho_4"></div>
                        </div>
                        <div class="content_box">
                            <div class="content_box_in  trans">
                                <?php the_title( '<h2 class="title_22"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>' ); ?>
                                <?php $excerpt = '';
                                if (has_excerpt()): ?>
                                    <p>
                                    <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                        echo esc_attr($excerpt);
                                    ?>
                                    </p> 
                                <?php endif; ?>
                                <a href="<?php echo esc_url(get_permalink()); ?>" class="lnk trans">
                                    <svg class="trans" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 7.75H16M16 7.75L9.25 1M16 7.75L9.25 14.5" stroke="#008BF9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>

                    <?php // portfolio style ?>
					    <?php else: ?>
                    <?php // portfolio style ?>    
                      
                    <div class="portfolio_box type_two">
                        <div class="image_box ">
                            <?php the_post_thumbnail(); ?>
                            <a data-fancybox="gallery" class="zm_btn trans"
                                href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>">
                                <span class="fi-rs-cursor-plus zoom_icon"></span>
                            </a>
                        </div> 
                    <div class="content_box  trans">
                        <div class="bg trans"></div>
                            <div class="con">
                                <?php the_title( '<h2 class="title_30"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>' ); ?>
                                <?php $excerpt = '';
                                if (has_excerpt()): ?>
                                    <p>
                                    <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                        echo esc_attr($excerpt);
                                    ?>
                                    </p> 
                                <?php endif; ?>
                            </div>
                            <a href="<?php echo esc_url(get_permalink()); ?>" class="lnk trans">
                                <svg class="trans" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1 7.75H16M16 7.75L9.25 1M16 7.75L9.25 14.5" stroke="#008BF9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                    <?php // portfolio style ?>              
                        <?php endif; ?>
                    <?php // portfolio style ?>                        
	
                    <?php endwhile; // while loop end ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; // Post Endif after loop end  ?>
        </div>
   
   
</section>
 
        <?php
    }
}

         