<?php

namespace  Vankineaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Logo extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-logo-v1';
    }

    public function get_title()
    {
        return __('Logo V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('logo_content',
        [ 
            'label' => __('Logo Settings', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );

        $this->add_control(
            'logo_default',
        [
            'label' => __( 'Logo Default', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => VANKINE_ADDONS_URL . '/assets/imgs/logo-white.svg',
            ],
        ] 
       );
    
    
       $this->add_control(
        'logo_width',
        [
            'label' => __( 'Logo Width', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( '170px', 'vankine-addons' ),
            'placeholder' => __( 'Enter logo width here in (px , rem and em )', 'vankine-addons' ),
            'selectors' => [
                '{{WRAPPER}}  .logo_box img' => 'width: {{VALUE}}!important; display:block;',
            ],
        ]
        ); 
        $this->add_control(
            'margin_logo',
            [
                'label' => __( 'Margin', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}}  .logo_box img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
        $this->add_control(
            'custom_link_enable',
            [
                'label' => __('Custom Link show / hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
    
    
        $this->add_control(
            'logo_link',
            [
                'label' => __( 'Link', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'vankine-addons' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'custom_link_enable' => 'yes'
                ],
            ]
        );
    
        $this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0 auto 0 0' => [
						'title' => esc_html__( 'Left', 'vankine-addons' ),
						'icon' => 'eicon-text-align-left',
					],
					'0 auto' => [
						'title' => esc_html__( 'Center', 'vankine-addons' ),
						'icon' => 'eicon-text-align-center',
					],
					'0 0 0 auto' => [
						'title' => esc_html__( 'Right', 'vankine-addons' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '0 auto 0 0',
				'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .logo_box a img' => 'margin: {{VALUE}}!important;',
                ],
			]
		);

$this->end_controls_section(); 

} 
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
$url = '';
if($settings['custom_link_enable'] == 'yes'):
$logo_target = $settings['logo_link']['is_external'] ? ' target="_blank"' : '';
$logo_nofollow = $settings['logo_link']['nofollow'] ? ' rel="nofollow"' : ''; 
    $url = $settings['logo_link']['url'];
else:
    $url = home_url();
endif;
?>
<div class="logo_box"> 
    <a href="<?php echo esc_url($url); ?>" class="logo d-block navbar-brand"
        <?php if($settings['custom_link_enable'] == 'yes'): echo esc_attr($logo_target);  echo esc_attr($logo_nofollow); endif; ?>>
        <img src="<?php echo esc_url($settings['logo_default']['url']); ?>" width="100" height="70"
            alt="<?php echo esc_html(get_bloginfo( 'name' )); ?>" class="logo_default">
    </a>
</div>
<?php
    }
}