<?php

namespace  Vankineaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Header_v2 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-header-v2';
    }

    public function get_title()
    {
        return __('Prebuilt Header V2', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('headers_settings',
        [ 
            'label' => __('Header Settings', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        ); 
        $this->add_control(
            'header_absolute',
            [
                'label' => __('Position Absolute  Enable / Disable', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
 
        $this->add_control(
            'logo_default',
        [
            'label' => __( 'Logo Default', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => VANKINE_ADDONS_URL . '/assets/imgs/logo-white.svg',
            ],
        ] 
       );
      
       $this->add_control(
        'logo_width',
        [
            'label' => __( 'Logo Width', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( '170px', 'vankine-addons' ),
            'placeholder' => __( 'Enter logo width here in (px , rem and em )', 'vankine-addons' ),
            'selectors' => [
                '{{WRAPPER}} .header-area .logo_box img , {{WRAPPER}} .header-area .logobox img' => 'width: {{VALUE}}!important;',
            ],
        ]
        );
        $this->add_control(
            'margin_logo',
            [
                'label' => __( 'Margin', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .header-area .logo_box img , {{WRAPPER}} .header-area .logobox img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
        $this->add_control(
            'custom_link_enable',
            [
                'label' => __('Custom Link show / hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
    
    
        $this->add_control(
            'logo_link',
            [
                'label' => __( 'Link', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'vankine-addons' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'custom_link_enable' => 'yes'
                ],
            ]
        );
  
      
        $this->add_control(
            'hrlo_seven',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
            $this->add_control(
                'navigations',
                [
                    'label' => __('Select Navigation', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::SELECT2,
                    'options' => vankine_navmenu(),
                ]
            );
                
            $this->add_control(
                'hr_seven',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER, 
                ]
            );
            

            $this->add_control(
                'search_enable',
                [
                    'label' => __('Search show / hide', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', 'vankine-addons'),
                    'label_off' => __('No', 'vankine-addons'),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            $this->add_control(
                'hr_five_f',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER,
                ]
            );
            $this->add_control(
                'media_enable',
                [
                    'label' => __('Media show / hide', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', 'vankine-addons'),
                    'label_off' => __('No', 'vankine-addons'),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            
            $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                'media_icon',
            [
                'label' => esc_html__('Media Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('fa-brands fa-facebook' , 'vankine-addons'),
            ]);
           
            
            $repeater->add_control(
                'media_link',
                [
                    'label' => __('Link', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::URL,
                    'placeholder' => __('https://your-link.com', 'vankine-addons'),
                    'show_external' => true,
                    'default' => [
                        'url' => '#',
                        'is_external' => false,
                        'nofollow' => false,
                    ],
                ]
            );
          
          $this->add_control(
            'media_repeater',
            [
                'label' => __('Media Repeater', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'media_icon' =>  __('fa-brands fa-facebook','vankine-addons'),
                    ],
                    [
                        'media_icon' =>  __('fa-brands fa-twitter','vankine-addons'),
                    ],
                    [
                        'media_icon' =>  __('fa-brands fa-skype','vankine-addons'),
                    ],
                    [
                        'media_icon' =>  __('fa-brands fa-instagram','vankine-addons'),
                    ]
                    
                ],
                'title_field' => '{{{ media_icon }}}',
            ]);
    
 
            $this->add_control(
                'hr_five_fu',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER,
                ]
            );
            $this->add_control(
                'button_enable',
                [
                    'label' => __('Button show / hide', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', 'vankine-addons'),
                    'label_off' => __('No', 'vankine-addons'),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            $this->add_control(
                'button_texts',
                [
                    'label' => __( 'Button Text', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __( 'Get A Quote', 'vankine-addons' ),
                    'placeholder' => __( 'Type your title here', 'vankine-addons' ),
                    'condition' => [
                        'button_enable' => 'yes'
                    ],
                ]
            );
            $this->add_control(
                'button_link',
                [
                    'label' => __( 'Button Link', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::URL,
                    'placeholder' => __( 'https://your-link.com', 'vankine-addons' ),
                    'show_external' => true,
                    'default' => [
                        'url' => '',
                        'is_external' => true,
                        'nofollow' => true,
                    ],
                    'condition' => [
                        'button_enable' => 'yes'
                    ],
                ]
            );
        
        
 $this->end_controls_section();
 
$this->start_controls_section('header_bg_css',
[ 
    'label' => __('Header  Bg Css', 'vankine-addons'),
    'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
]);

$this->add_responsive_control(
    'header_bg_color',
     [
        'label' => __('Header Bg Color', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .header-area.header-style-2 ' => 'background: {{VALUE}}!important;',
        ],
     ]
); 


$this->end_controls_section();

$this->start_controls_section('menu_css',
    [ 
        'label' => __('Menu Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]);

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Menu Typography', 'vankine-addons' ),
            'name' => 'menu_typo',
            'selector' => '{{WRAPPER}} .header-area .navbar_nav>.menu-item a.nav_link ',
        ]
    );

    $this->add_responsive_control(
        'menu_item_padding',
        [
            'label' => esc_html__( 'Menu Item Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
	$this->add_responsive_control(
        'menu_item_margin',
        [
            'label' => esc_html__( 'Menu Item Margin', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'menu_item_color',
        [
            'label' => __('Menu Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > a.nav_link  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
	$this->add_responsive_control(
        'menu_item_bg_color',
        [
            'label' => __('Menu Item Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item    ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'menu_item_active_colosr',
        [
            'label' => __('Menu Active / Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .current_page_item > a.nav_link , {{WRAPPER}} .navbar_nav > .menu-item > a.nav_link:hover  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    );
	$this->add_responsive_control(
        'menu_itemac_bg_colorss',
        [
            'label' => __('Menu Item Active / Hover Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item.current_page_item , {{WRAPPER}} .navbar_nav > .menu-item:hover  ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'menu_item_arrow_color',
        [
            'label' => __('Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > li > .dropdown-btn .fa-angle-down  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'arrow_move_right',
        [
            'label' => __('Arrow Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 1,
            'min'     => -150,
            'max'     => 150,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > li > .dropdown-btn .fa-angle-down ' => 'right: {{VALUE}}px!important; position:relative;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'multiple_dropborder_color',
        [
            'label' => esc_html__( 'Dropdown Tile Border Color', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .menu_boxed .navbar_nav .mennucolumn_two > ul > li > a , {{WRAPPER}}   .menu_boxed .navbar_nav .mennucolumn_three > ul > li > a,  {{WRAPPER}}  .menu_boxed .navbar_nav .mennucolumn_four > ul > li > a, {{WRAPPER}}  .menu_boxed .navbar_nav .mennucolumn_five > ul > li > a, {{WRAPPER}}  .default_header .navbar_nav .mennucolumn_two > ul > li > a, {{WRAPPER}}  .default_header .navbar_nav .mennucolumn_three > ul > li > a, {{WRAPPER}}  .default_header .navbar_nav .mennucolumn_four > ul > li > a, {{WRAPPER}}  .default_header .navbar_nav .mennucolumn_five > ul > li > a, body .menu_content_in .navbar_nav .mennucolumn_two > ul > li > a, {{WRAPPER}}  .menu_content_in .navbar_nav .mennucolumn_three > ul > li > a, {{WRAPPER}}  .menu_content_in .navbar_nav .mennucolumn_four > ul > li > a, {{WRAPPER}}  .menu_content_in .navbar_nav .mennucolumn_five > ul > li > a' => 'border-color: {{VALUE}}!important;',
            ], 
        ]
    );
    $this->add_responsive_control(
        'drop_down_menuarr_color',
        [
            'label' => __('Drop Down Menu Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav   .menu-item  .sub_menu .dropdown-btn .fa-angle-down  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'drop_down_menu_color',
        [
            'label' => __('Drop Down Menu Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'dmenu_item_border',
        [
            'label' => esc_html__( 'Dropdown Menu Item Border Width', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'dmenu_item_border_types',
        [
          'label' => __('Dropdown Menu Item Border Type', 'vankine-addons'),
          'type' => \Elementor\Controls_Manager::SELECT,
          'options' => [
            'none' => __( 'None', 'vankine-addons' ),
            'solid' => __( 'Solid', 'vankine-addons' ),
            'dashed' => __( 'Dashed', 'vankine-addons' ),
            'dotted' => __( 'Dashed', 'vankine-addons' ),
          ],
          'default' => '' , 
          'selectors' => [
            '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'border-style: {{VALUE}}!important;',
        ],
        ]
     );
    $this->add_responsive_control(
        'dropbr_down_menu_color',
        [
            'label' => __('Drop Down Menu Border  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'drop_down_menubg_color',
        [
            'label' => __('Drop Down Menu Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 

    $this->add_responsive_control(
        'hover_drop_down_menu_color',
        [
            'label' => __('Drop Down Menu Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a:hover ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'hover_drop_downbr_menu_color',
        [
            'label' => __('Drop Down Menu Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a:hover ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'hover_drop_down_bgmenu_color',
        [
            'label' => __('Drop Down Menu Hover Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a:hover ' => 'background: {{VALUE}}!important;',
            ],
        ]
    );  
    $this->add_responsive_control(
        'dmenu_item_paddings',
        [
            'label' => esc_html__( 'Dropdown Menu Item Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                '{{WRAPPER}} .navbar_nav ul li a ' => 'margin-bottom:0!important;',
            ],
        ]
    );
   
	$this->add_responsive_control(
        'dmenu_item_margin',
        [
            'label' => esc_html__( 'Dropdown Menu Item Margin', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'mutiple_column_gap',
        [
            'label' => __('Mutiple Dropdown Column Gap', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 1,
            'min'     => 0,
            'max'     => 200,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav .sub_menu ' => 'gap: {{VALUE}}px!important;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'drop_down_bg_color',
        [
            'label' => __('Drop Down Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav .menu-item .sub_menu ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'dmenu_box_padding',
        [
            'label' => esc_html__( 'Dropdown  Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav .menu-item .sub_menu ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'navigation_btn_color',
        [
            'label' => __('Mobile Navigation Button  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .header-area .navbar_togglers  .line' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->end_controls_section(); 

    $this->start_controls_section('media_css',
    [ 
        'label' => __('Media  Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]);
    
     
    $this->add_responsive_control(
        'color_one',
        [
            'label' => __( 'Icon Color', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .social-icons ul li a ' => 'color: {{VALUE}}',
            ],
        ]
    );
    
     
    $this->add_responsive_control(
        'color_three',
        [
            'label' => __( 'Icon Hover Color', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .social-icons ul li a:hover ' => 'color: {{VALUE}}',
            ],
        ]
    );
    
      
    $this->end_controls_section(); 
            
        $this->start_controls_section('button_css',
        [ 
            'label' => __('Header Button Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]);


        $this->add_responsive_control(
        'button_color',
        [
            'label' => __('Button Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .theme_btn ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}}  .theme_btn svg path  ' => 'stroke: {{VALUE}}!important;',
            ],
        ]
        );

        $this->add_responsive_control(
        'background_color',
        [
            'label' => __('Button Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .theme_btn  ' => 'background: {{VALUE}}!important;',
            ],
        ]
        );

        $this->add_responsive_control(
        'border_color',
        [
            'label' => __('Button Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .theme_btn  ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
        );

        $this->add_responsive_control(
            'border_radius',
            [
                'label' => __( 'Border Radius', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .theme_btn    ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_responsive_control(
        'button_color_hover',
        [
            'label' => __('Button Hover Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .theme_btn:hover ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}}  .theme_btn:hover svg path  ' => 'stroke: {{VALUE}}!important;',
            ],
        ]
        );

        $this->add_responsive_control(
        'background_color_hover',
        [
            'label' => __('Button Hover Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .theme_btn:hover ' => 'background: {{VALUE}}!important;',
            ],
        ]
        );

        $this->add_responsive_control(
        'border_color_hover',
        [
            'label' => __('Button Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .theme_btn:hover ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
        );


        $this->end_controls_section();


        $this->start_controls_section('header_extra_css',
        [ 
            'label' => __('Search  Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_responsive_control(
            'search_inpur_colors',
            [
                'label' => __('Search Input Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-area.header-style-2 .right_content .search_form form input , {{WRAPPER}} .header-area.header-style-2 .right_content .search_form form input::placeholder' => 'color: {{VALUE}}!important;',
                ],
                 
            ]
        ); 
        $this->add_responsive_control(
            'search_brcolor_color',
            [
                'label' => __('Search Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-area.header-style-2 .right_content .search_form form input' => 'border-color: {{VALUE}}!important;',
                ],
                 
            ]
        ); 

        $this->add_responsive_control(
            'icon_color',
            [
                'label' => __('Search Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-area.header-style-2 .right_content .search_form form .sch_btn i' => 'color: {{VALUE}}!important;',
                ],
               
            ]
        ); 

         
    
    $this->end_controls_section(); 

    $this->start_controls_section('menubacss',
    [ 
        'label' => __('Menu Bar Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]);

    $this->add_responsive_control(
        'navigationcss',
        [
            'label' => __('Navigation Css', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_togglers.hamburger_menu .line ' => 'background-color: {{VALUE}}!important;',
            ],
             
        ]
    ); 
     
 
    $this->end_controls_section(); 

} 
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
$url = '';
if($settings['custom_link_enable'] == 'yes'):
$logo_target = $settings['logo_link']['is_external'] ? ' target="_blank"' : '';
$logo_nofollow = $settings['logo_link']['nofollow'] ? ' rel="nofollow"' : ''; 
    $url = $settings['logo_link']['url'];
else:
    $url = home_url();
endif;
?>

<header class="header-area header-style-2<?php if($settings['header_absolute'] == 'yes'): ?> absolute<?php endif; ?>">

    <div class="main_header_content default_header">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <div class="col-xl-2 col-lg-2 col-md-11 col-sm-11 col-xs-11">
                    <div class="logobox">
                        <a href="<?php echo esc_url($url); ?>" class="logo navbar-brand"
                            <?php if($settings['custom_link_enable'] == 'yes'): echo esc_attr($logo_target);  echo esc_attr($logo_nofollow); endif; ?>>
                            <img src="<?php echo esc_url($settings['logo_default']['url']); ?>" width="100" height="70"
                                alt="<?php echo esc_html(get_bloginfo( 'name' )); ?>" class="logo_default">
                        </a>
                    </div>
                </div>
                <div class="col-xl-10 col-lg-10 col-md-1 col-sm-1 col-xs-1 column_menu">
                <div class="navbar_togglers hamburger_menu">
                            <span class="line"></span>
                            <span class="line"></span>
                            <span class="line"></span>
                        </div>
                <div class="d-flex right_content align-items-center">
                    <div class="navbar_content">
                        <?php if(!empty($settings['navigations'])):
                            wp_nav_menu(array(
                                'menu' => $settings['navigations'],
                                'container' => false,
                                'menu_class' => 'navbar_nav',
                                'fallback_cb'    => 'Vankine_WP_Bootstrap_Navwalker::fallback',
                                'walker' => new \Vankine_WP_Bootstrap_Navwalker()
                            )); 
                        endif; ?>

                    </div>
          
                        <?php if($settings['search_enable'] == 'yes'): ?>
                        <div class="search_form">
                        <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
                              <input type="search" class="search" placeholder="<?php echo esc_attr__( 'Search...', 'vankine' ); ?>" value="<?php echo get_search_query() ?>" name="s" title="Search" />
                              <button type="submit" class="sch_btn"> <i class="fi-rs-search"></i></button>
                          </form>
                        </div>
                        <?php endif;?>
                        <?php if($settings['media_enable'] == 'yes'): ?>
                        <div class="social-icons">
                            <ul>
                                <?php foreach($settings['media_repeater'] as $media): 
                                $mtarget = $media['media_link']['is_external'] ? ' target="_blank"' : '';
                                $mnofollow = $media['media_link']['nofollow'] ? ' rel="nofollow"' : '';
                                ?>
                                <li><a href="<?php echo esc_url($media['media_link']['url']); ?>" class="m_icon"
                                        <?php echo esc_attr($mtarget); ?> <?php echo esc_attr($mnofollow); ?>> <i
                                            class="<?php echo esc_attr($media['media_icon']); ?>"></i>

                                    </a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <?php endif;?>
                        <?php if($settings['button_enable'] == 'yes'): ?>
                        <div class="button">
                            <?php $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
                           $nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                            <a href="<?php echo esc_url($settings['button_link']['url']); ?>"
                                <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?> class="theme_btn">
                                <?php echo esc_attr($settings['button_texts']); ?>
                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1 11L11 1M11 1H3.5M11 1V8.5" stroke="white" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>


                            </a>
                        </div>
                        <?php endif;?>
                    </div>

                </div>
            </div>
        </div>
    </div>

</header>


<?php
    }
}