<?php

namespace  Vankineaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Contact_header_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-contact-header-v1';
    }

    public function get_title()
    {
        return __('Header Contact V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('header_contact_settings',
        [ 
            'label' => __('Header Contact Settings', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
    );

    $this->add_control(
        'contact_types',
        [
          'label' => __('Contact Types', 'vankine-addons'),
          'type' => \Elementor\Controls_Manager::SELECT,
          'options' => [
            'mail' => __( 'Mail', 'vankine-addons' ),
            'phone' => __( 'Phone', 'vankine-addons' ),
            'custom_content' => __( 'Custom Content', 'vankine-addons' ), 
        ],
          'default' => 'mail' , 
        ]
     );

 
    $this->add_control(
        'switcher_c_icon',
        [
            'label' => esc_html__( 'Use Custom Icon', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
            'label_off' => esc_html__( 'No', 'vankine-addons' ),
            'return_value' => 'yes',
            'default' => '',
        ]
    );
    
    $this->add_control(
        'icon',
        [
            'label' => __('Icon', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => vankine_get_icon(),
            'default' => 'fi-rs-user' , 
            'condition' => [
                'switcher_c_icon' => 'yes' ,
            ]
        ]
    );
    $this->add_control(
        'icon_lib',
        [
            'label' => __('Icon', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fab fa-facebook-f',
                'library' => 'fa-brands',
            ],
            'label_block' => true,
            'condition' => [
                'switcher_c_icon' => '',
            ]
        ]
    );

    $this->add_control(
        'title',
        [
            'label' => __( 'Title', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( 'Our Locations', 'vankine-addons' ),
        ]
    );
    $this->add_control(
        'mail',
        [
            'label' => __( 'Mail', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( 'example@gmail.com', 'vankine-addons' ),
            'condition' => [
                'contact_types' => 'mail'
            ],
        ]
    );
    $this->add_control(
        'phone',
        [
            'label' => __( 'Phone', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( '+000(123)456 88', 'vankine-addons' ),
            'condition' => [
                'contact_types' => 'phone'
            ],
        ]
    );

    $this->add_control(
        'content',
        [
            'label' => __( 'Content', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( '55 Main Street, USA', 'vankine-addons' ),
            'condition' => [
                'contact_types' => 'custom_content'
            ],
        ]
    );
    
    $this->end_controls_section();

        

        $this->start_controls_section('header_contact_css',
        [ 
            'label' => __('Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s i ' => 'color: {{VALUE}}!important;',
                    '{{WRAPPER}} .contact_header_one .icon_s svg path ' => 'fill: {{VALUE}}!important;',
                ],
            
            ]
        ); 

        $this->add_control(
            'icon_border_color',
            [
                'label' => __('Icon Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s  ' => 'border-color: {{VALUE}}!important;',
                ],
            
            ]
        ); 
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Icon Background Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s  ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'icon_font_size',
            [
                'label' => __('Icon Font Size', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 200,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s i' => 'font-size: {{VALUE}}px!important;',
                    '{{WRAPPER}} .contact_header_one .icon_s svg' => 'width: {{VALUE}}px!important;',
                ],
            ]
        );
        $this->add_control(
            'icon_width',
            [
                'label' => __('Icon Width', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 50,
                'min'     => 1,
                'max'     => 200,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s ' => 'width: {{VALUE}}px!important;',
                ],
            ]
        );

        $this->add_control(
            'icon_height',
            [
                'label' => __('Icon Height', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 50,
                'min'     => 1,
                'max'     => 200,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s  ' => 'height: {{VALUE}}px!important;',
                    '{{WRAPPER}} .contact_header_one .icon_s i  ' => 'line-height: {{VALUE}}px!important;',
                    '{{WRAPPER}} .contact_header_one .icon_s svg  ' => 'line-height: {{VALUE}}px!important;',
                ],
            ]
        );

        $this->add_control(
            'icon_radius',
            [
                'label' => esc_html__( 'Icon Border Radius', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .icon_s  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Title Typography', 'vankine-addons' ),
				'name' => 'title_typo',
				'selector' => '{{WRAPPER}} .contact_header_one .content .tite ',
			]
		);
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .content .tite ' => 'color: {{VALUE}}!important;',
                ],
            
            ]
        ); 
        $this->add_responsive_control(
            'marginbottom',
            [
                'label' => __('Margin Bottom', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 50,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .content .tite ' => 'margin-bottom: {{VALUE}}px!important;',  
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Content Typography', 'vankine-addons' ),
				'name' => 'contypo',
				'selector' => '{{WRAPPER}} .contact_header_one .content .title_20 a , {{WRAPPER}} .contact_header_one .content .title_no_a_20 ',
			]
		);
        $this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_header_one .content .title_20 a , {{WRAPPER}} .contact_header_one .content .title_no_a_20 ' => 'color: {{VALUE}}!important;',
                ],
            
            ]
        ); 

        $this->end_controls_section(); 

} 
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
?>
<div class="d-flex align-items-center contact_header_one">
        <?php if($settings['switcher_c_icon'] == 'yes'): ?>
            <?php if(!empty($settings['icon'])): ?>
                <div class="icon_s">
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                </div>
            <?php endif; ?>	
            <?php else: ?>
            <?php if(!empty($settings['icon_lib'])): ?>
                <div class="icon_s">
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                </div>
            <?php endif; ?>	
        <?php endif; ?>	
        <div class="content">
            <h6 class="tite"><?php echo wp_kses($settings['title'] , $allowed_tags); ?></h6>
            <?php if($settings['contact_types'] == 'phone'): ?>
                <div class="title_20"><a href="tel:<?php echo esc_attr($settings['phone']); ?>"><?php echo esc_attr($settings['phone']); ?></a></div>
            <?php elseif($settings['contact_types'] == 'mail'): ?>
                <div class="title_20"><a href="mailto:<?php echo esc_attr($settings['mail']); ?>"><?php echo esc_attr($settings['mail']); ?></a></div>
            <?php elseif($settings['contact_types'] == 'custom_content'): ?>
                <div class="title_no_a_20"><?php echo wp_kses($settings['content'] , $allowed_tags); ?></div>
            <?php endif; ?>
        </div>
</div>

 


<?php
    }
}