<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Tab_with_content_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-tab-with-content-v1';
    }

    public function get_title()
    {
        return __('Tab With Content V1' , 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }
 
    protected function register_controls() {
		$this->start_controls_section(
			'tab_content',
			[
				'label' => esc_html__( 'Tab Content', 'vankine-addons' ),
			]
        );

        $this->add_control(
            'type_tabs',
            [
            'label' => __('Tab Style', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'vankine-addons' ),
                'style_two' => __( 'Style Two', 'vankine-addons' ),
            ],
            'default' => 'style_one' , 
            ]
        );

        $this->add_control(
            'content_center',
            [
                'label' => esc_html__( 'Content Center Enable / Disable', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

       
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'tab_title',
            [
                'label'       => esc_html__( 'Tab Title', 'vankine-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Planting' , 'vankine-addons'),
            ]
        );
        $repeater->add_control(
            'tab_id',
            [
                'label'       => esc_html__( 'Tab ID', 'vankine-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'tab_default' , 'vankine-addons'),
                'description' =>  esc_html__( 'Please Enter the tab id like this example : (tab_one , tab_two , tab_three)' , 'vankine-addons'),
            ]
        );
        $repeater->add_control(
            'tab_content',
            [
                'label'       => esc_html__( 'Tab Content', 'vankine-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam aperiam, eaquecy epsa abillo inventore veritatis architecto beatae' , 'vankine-addons'),
            ]
        ); 
        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => vankine_get_icon(),
                'default' => 'fi-rs-user' , 
                
            ]
        );
        
        $repeater->add_control(
            'tab_list_items',
            [
                'label'       => esc_html__( 'Tab List Items', 'vankine-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'Best Insurance Agency
                Trusted & Experience Insurance
                Dedicated Support & Security' , 'vankine-addons'), 
            ]
        );
        $repeater->add_control(
            'tab_list_items_two',
            [
                'label'       => esc_html__( 'Tab List Items', 'vankine-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default' =>  esc_html__( 'Best Insurance Agency
                Trusted & Experience Insurance
                Dedicated Support & Security' , 'vankine-addons'), 
            ]
        );

        $this->add_control(
            'content_repeater',
            [
                'label' => __( 'Tab Content Repeater', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => __( 'About Us', 'vankine-addons' ),
                        'tab_id' => __( 'tab1', 'vankine-addons' ),
                        'tab_content' => __( 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam aperiam, eaquecy epsa abillo inventore veritatis architecto beatae', 'vankine-addons' ),
                        'tab_list_items' => __( 'Best Insurance Agency
                        Trusted & Experience Insurance
                        Dedicated Support & Security', 'vankine-addons' ),
                        'tab_list_items_two' => __( 'Best Insurance Agency
                        Trusted & Experience Insurance
                        Dedicated Support & Security', 'vankine-addons' ),
                    ],
                    [
                        'tab_title' => __( 'Mission', 'vankine-addons' ),
                        'tab_id' => __( 'tab2', 'vankine-addons' ),
                        'tab_content' => __( 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam aperiam, eaquecy epsa abillo inventore veritatis architecto beatae', 'vankine-addons' ),
                        'tab_list_items' => __( 'Best Insurance Agency
                        Trusted & Experience Insurance
                        Dedicated Support & Security', 'vankine-addons' ),
                        'tab_list_items_two' => __( 'Best Insurance Agency
                        Trusted & Experience Insurance
                        Dedicated Support & Security', 'vankine-addons' ),
                    ],
                    [
                        'tab_title' => __( 'Vission', 'vankine-addons' ),
                        'tab_id' => __( 'tab3', 'vankine-addons' ),
                        'tab_content' => __( 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam aperiam, eaquecy epsa abillo inventore veritatis architecto beatae', 'vankine-addons' ),
                        'tab_list_items' => __( 'Best Insurance Agency
                        Trusted & Experience Insurance
                        Dedicated Support & Security', 'vankine-addons' ),
                        'tab_list_items_two' => __( 'Best Insurance Agency
                        Trusted & Experience Insurance
                        Dedicated Support & Security', 'vankine-addons' ),
                    ] 
                ],
                'title_field' => '{{{tab_title}}}',
            ]
        );
 
     $this->end_controls_section(); 

     $this->start_controls_section('title_css',
     [ 
         'label' => __('Title Css', 'vankine-addons'),
         'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
     ]
     );
     $this->add_control(
        'nav_bg_color',
         [
            'label' => __('Tab Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .only_tab_content .nav-tabs ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Tab Button Typography', 'vankine-addons' ),
            'name' => 'tab_typo',
            'selector' => '{{WRAPPER}} .custom_tabs .nav-tabs li .nav-link',
        ]
    );
     $this->add_control(
        'tab_text_color',
         [
            'label' => __('Tab Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .custom_tabs .nav-tabs li .nav-link , {{WRAPPER}} .only_tab_content .nav-tabs li .nav-link svg path' => 'color: {{VALUE}}!important; stroke: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'tab_text_bg_color',
         [
            'label' => __('Tab Text Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .custom_tabs .nav-tabs li .nav-link' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'tab_padding',
        [
            'label' => __( 'Button Padding ', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px'],
            'selectors' => [
                '{{WRAPPER}} .custom_tabs .nav-tabs li .nav-link  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'tab_btn_radius',
        [
            'label' => __( 'Button Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px'],
            'selectors' => [
                '{{WRAPPER}} .custom_tabs .nav-tabs li .nav-link  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'tab_text_ho_color',
         [
            'label' => __('Hover Tab Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .custom_tabs  .nav-tabs li .nav-link.active, {{WRAPPER}}  .custom_tabs  .nav-tabs li .nav-link:hover , {{WRAPPER}} .only_tab_content .nav-tabs li .nav-link.active svg path , {{WRAPPER}} .only_tab_content .nav-tabs li .nav-link:hover svg path' => 'color: {{VALUE}}!important; stroke: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'tab_text_ho_bg_color',
         [
            'label' => __('Hover Tab Text Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .custom_tabs  .nav-tabs li .nav-link.active, {{WRAPPER}}  .custom_tabs  .nav-tabs li .nav-link:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'colo',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
    );
 

     $this->add_control(
        'content_color',
         [
            'label' => __('Content Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .only_tab_content .tab_content_box .content ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Content Typography', 'vankine-addons' ),
            'name' => 'content_typo',
            'selector' => '{{WRAPPER}} .only_tab_content .tab_content_box .content',
        ]
    );
    $this->add_control(
        'icon_color',
         [
            'label' => __('Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .only_tab_content .tab_content_box ul li svg circle' => 'fill: {{VALUE}}!important;',
                '{{WRAPPER}} .only_tab_content .tab_content_box ul li i' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'List Typo Typography', 'vankine-addons' ),
            'name' => 'list_typo',
            'selector' => '{{WRAPPER}} .only_tab_content .tab_content_box ul li',
        ]
    );
    $this->add_control(
        'list_color',
         [
            'label' => __('List Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .only_tab_content .tab_content_box ul li  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'icon_font_size',
         [
            'label' => __('Icon Font Size', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '20',
            'min'     => -100,
            'max'     => 110,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}}  .only_tab_content .tab_content_box ul li i ' => 'font-size: {{VALUE}}px!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'icon_top',
         [
            'label' => __('Icon Move Top', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '0',
            'min'     => -100,
            'max'     => 110,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}}  .only_tab_content .tab_content_box ul li i ' => 'top: {{VALUE}}px!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'icon_right',
         [
            'label' => __('Icon Move Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => '0',
            'min'     => -100,
            'max'     => 110,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .only_tab_content .tab_content_box ul li i ' => 'margin-right: {{VALUE}}px!important;',
            ],
           
         ]
    );
    $this->add_responsive_control(
        'rtlicon_right',
        [
            'label' => __('Icon Margin Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' =>  0,
            'min'     => -150,
            'max'     => 150, 
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .only_tab_content .tab_content_box ul li i  ' => 'margin-left: {{VALUE}}px!important;', 
            ],
        ]
    );
     
    $this->end_controls_section();
}
protected function render() {
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
$content_repeaters = $settings['content_repeater'];
?>
 
    <section class="fom_tab_box custom_tabs only_tab_content <?php echo esc_attr($settings['type_tabs']); ?> <?php if($settings['content_center'] == 'yes'): ?> content_center<?php endif; ?>">
    <ul class="nav nav-tabs links trans"  role="tablist">
                <?php if(!empty($content_repeaters)): ?>
                    <?php foreach($content_repeaters as $key => $content_repeater): ?>
                        <li class="nav-item">
                      
                                <button class="nav-link <?php if($key == 0) echo 'active';?>" id="<?php echo esc_attr($content_repeater['tab_id']);?>-tabtab" data-bs-toggle="tab" data-bs-target="#<?php echo esc_attr($content_repeater['tab_id']);?>" type="button" role="tab" aria-controls="<?php echo esc_attr($content_repeater['tab_id']);?>" aria-selected="false">
                                <?php echo esc_attr($content_repeater['tab_title']);?>
                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1 11L11 1M11 1H3.5M11 1V8.5" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>

                            </button>
                        </li>
                    <?php endforeach; ?>
                <?php endif; ?>
            </ul>
        
                <div class="s_tabs_content tab-content">
                <?php if(!empty($content_repeaters)): ?>
                    <?php foreach($content_repeaters as $key => $content_repeater): ?>
 
                    <div class="tab-pane  <?php if($key == 0) echo 'active';?>" id="<?php echo esc_attr($content_repeater['tab_id']);?>" role="tabpanel" aria-labelledby="<?php echo esc_attr($content_repeater['tab_id']);?>-tabtab">
                        <div class="tab_content_box">
                            <?php if(!empty($content_repeater['tab_content'])): ?>
                                <div class="content">
                                    <?php echo wp_kses($content_repeater['tab_content'] , $allowed_tags); ?>
                                </div>
                            <?php endif; ?>
                            <div class="d-flex">
                            <?php if(!empty($content_repeater['tab_list_items'])): ?>
                                <ul>
                                    <?php $tab_list_items = explode("\n", ($content_repeater['tab_list_items']));?>
                                    <?php foreach($tab_list_items as $tab_list_item):?>
                                    <li>
                                  
                <div class="icon">
                <?php if(!empty($content_repeater['icon'])): ?>
                    <i class="<?php echo esc_attr($content_repeater['icon']); ?>"></i>
		        <?php else: ?>
                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12.5" cy="12.5" r="12.5" fill="#36DB9F"></circle>
<g>
<path d="M11.8363 18.7066C12.2244 19.0994 13.0886 18.9692 13.1817 18.3516C13.7607 14.5175 16.6577 11.2829 18.85 8.23494C19.4579 7.39031 18.0602 6.58795 17.4602 7.42252C15.4568 10.2075 12.9317 13.138 11.9439 16.5174C10.815 15.3637 9.68161 14.221 8.41548 13.2072C7.61364 12.5649 6.46665 13.6965 7.27713 14.3455C8.92674 15.6668 10.3523 17.2076 11.8363 18.7066Z" fill="white"></path>
</g>
<defs>
<clipPath>
<rect width="12" height="12" fill="white" transform="translate(7 7)"></rect>
</clipPath>
</defs>
</svg>
                <?php endif; ?>	
                </div>
   
                                        <span> <?php echo wp_kses($tab_list_item, true); ?></span>  
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                           <?php endif; ?>
                           <?php if(!empty($content_repeater['tab_list_items_two'])): ?>
                                <ul>
                                    <?php $tab_list_items_two = explode("\n", ($content_repeater['tab_list_items_two']));?>
                                    <?php foreach($tab_list_items_two as $tab_list_items_twos):?>
                                    <li>
                                
                <div class="icon">
                <?php if(!empty($content_repeater['icon'])): ?>
                    <i class="<?php echo esc_attr($content_repeater['icon']); ?>"></i>
		        <?php else: ?>
                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12.5" cy="12.5" r="12.5" fill="#36DB9F"></circle>
<g>
<path d="M11.8363 18.7066C12.2244 19.0994 13.0886 18.9692 13.1817 18.3516C13.7607 14.5175 16.6577 11.2829 18.85 8.23494C19.4579 7.39031 18.0602 6.58795 17.4602 7.42252C15.4568 10.2075 12.9317 13.138 11.9439 16.5174C10.815 15.3637 9.68161 14.221 8.41548 13.2072C7.61364 12.5649 6.46665 13.6965 7.27713 14.3455C8.92674 15.6668 10.3523 17.2076 11.8363 18.7066Z" fill="white"></path>
</g>
<defs>
<clipPath>
<rect width="12" height="12" fill="white" transform="translate(7 7)"></rect>
</clipPath>
</defs>
</svg>
                <?php endif; ?>	
                </div>
  
                                        <span> <?php echo wp_kses($tab_list_items_twos, true); ?></span>  
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                           <?php endif; ?>
                         </div>
                        </div>  
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
               
            </div>
    </section>
 
           
		<?php 
	}
}

 


