<?php
   namespace  Vankineaddons\Core\Widgets\Content;

   if (!defined('ABSPATH')) {
       exit;
   } // If this file is called directly, abort.
   
   class Mcforwp_v1  extends \Elementor\Widget_Base
   {
   
       public function get_name()
       {
           return 'creote-subscribe-v2';
       }
   
       public function get_title()
       {
           return __('MC4WP V1' , 'vankine-addons');
       }
   
       public function get_icon()
       {
        return 'icon-vankine-icon';
       }
   
       public function get_categories()
       {
           return ['101'];
       }
    
       protected function register_controls() {
            $this->start_controls_section(
               'subscribe_content',
               [
                   'label' => __('Subscribe  Content', 'vankine-addons')
               ]
           );
   
        
           $this->add_control(
               'subscribe_shortcode',
               [
               	'label'       => esc_html__( 'Shortcode', 'vankine-addons' ),
   				   'type'        => \Elementor\Controls_Manager::TEXTAREA,
                  'default' =>  esc_html__( '' , 'vankine-addons'),
                  'placeholder'  =>  esc_html__( '[mc4wp_form id="1174"]' , 'vankine-addons'),
               ]
           );
         
                     
            $this->add_control(
                'input_margin',
                [
                    'label' => esc_html__( 'Input  Margin', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"]  ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    ],
                ]
            );
            
             
            $this->add_control(
                'input_padding',
                [
                    'label' => esc_html__( 'Input padding', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"]  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    ],
                ]
            );
            
      
              
            $this->add_control(
                'input_border_radius',
                [
                    'label' => esc_html__( 'Input Border Radius', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"] ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    ],
                ]
            );
            
            $this->add_control(
                'input_border',
                [
                    'label' => esc_html__( 'Input Border Width', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"]  ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'input_border_stylesss',
                [
                'label' => __('Input Border Styles', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                  '' => __( 'Select', 'vankine-addons' ),
                    'solid' => __( 'Solid', 'vankine-addons' ),
                    'dotted' => __( 'Dotted', 'vankine-addons' ),
                    'dashed' => __( 'Dashed', 'vankine-addons' ),
                    'double' => __( 'Double', 'vankine-addons' ),
                    'none' => __( 'None', 'vankine-addons' ),
                ],
                'default' => __('' , 'vankine-addons'),
                'selectors' => [
                    '{{WRAPPER}} .newsteller_simple input[type="email"]  ' => 'border-style: {{VALUE}}!important;',
                ],
                ]
            );
            $this->add_control(
                'input_box_color',
                [
                    'label' => esc_html__( 'Input Box Shadow', 'textdomain' ),
                    'type' => \Elementor\Controls_Manager::BOX_SHADOW,
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"] ' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                    ],
                ]
            );
            $this->add_control(
                'input_border_color',
                 [
                    'label' => __('Input Border Color', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"] ' => 'border-color: {{VALUE}}!important;',
                    ],
                 ]
            );
            
            $this->add_control(
                'input_color',
                 [
                    'label' => __('Input   Color', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"] , {{WRAPPER}} .newsteller_simple input[type="email"]::placeholder ' => 'color: {{VALUE}}!important;',
                    ],
                 ]
            );
            
            
            
            $this->add_control(
                'input_bg',
                 [
                    'label' => __('Input Bg  Color', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"] ' => 'background-color: {{VALUE}}!important;',
                    ],
                 ]
            );
            
             
            $this->add_control(
                'input_height',
                [
                    'label' => esc_html__( 'Input   Height', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 1000,
                    'step' => 1,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="email"] ' => 'height: {{VALUE}}px!important;',
                    ],
                ]
            );


            $this->add_control(
                'colo',
                    [
                    'type' => \Elementor\Controls_Manager::DIVIDER, 
                    ]
            );

            $this->add_responsive_control(
                'button_position',
                [
                  'label' => __('Button Position', 'vankine-addons'),
                  'type' => \Elementor\Controls_Manager::SELECT,
                  'options' => [
                    'absolute' => __( 'Position Absolute', 'vankine-addons' ),
                    'relative' => __( 'Position Relative', 'vankine-addons' ),
                  ],
                  'default' => __('relative' , 'vankine-addons'),
                  'selectors' => [
                    '{{WRAPPER}}  .newsteller_simple input[type="submit"]  ' => 'position: {{VALUE}}; z-index:999; width:100%; left:0;',
                 ],
                ]
            );
 

            

        $this->add_control(
            'icon_moving_position',
            [
              'label'   => esc_html__( 'Button Moving Position', 'vankine-addons' ),
              'type'    => \Elementor\Controls_Manager::SELECT,
              'default' => 'top_right',
              'options' => array(
                'top_left' => esc_html__( 'Top Left', 'vankine-addons' ),
                'top_right' => esc_html__( 'Top Right', 'vankine-addons' ),
              ),
              'condition' => [
                'button_position' => 'absolute',
              ],
            ]
          );
          
          
          $this->add_control(
            'top_right_top',
            [
                'label' => esc_html__( 'Button Move Top', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => -1000,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'top: {{VALUE}}px!important;',
                ],
                'condition' => [
                  'icon_moving_position' => 'top_right',
                  'button_position' => 'absolute',
                ],
            ]
          );
          
          $this->add_control(
            'top_right_right',
            [
                'label' => esc_html__( 'Button Move Right', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => -1000,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'right: {{VALUE}}px!important; left:unset!important;',
                ],
                'condition' => [
                  'icon_moving_position' => 'top_right',
                  'button_position' => 'absolute',
                ],
            ]
          );
          
          $this->add_control(
            'top_left_top',
            [
                'label' => esc_html__( 'Button Move Top', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => -1000,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'top: {{VALUE}}px!important;',
                ],
                'condition' => [
                  'icon_moving_position' => 'top_left',
                  'button_position' => 'absolute',
                ],
            ]
          );
          
          $this->add_control(
            'top_left_left',
            [
                'label' => esc_html__( 'Button Move Left', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => -1000,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'left: {{VALUE}}px!important; right:unset!important;',
                ],
                'condition' => [
                  'icon_moving_position' => 'top_left',
                  'button_position' => 'absolute',
                ],
            ]
          );




            $this->add_responsive_control(
                'buton_alignmentss',
                [
                    'label' => __('Button alignments', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'options' => [
                      '0 0 auto 0' => [
                        'title' => __( 'Text Left', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-left',
                      ],
                      '0 auto' => [
                        'title' => __( 'Text Center', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-center',
                      ],
                      '0 auto 0 0' => [
                        'title' => __( 'Text Right', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-right',
                      ],
                    ],
                    'default' => '0 auto',
                    'toggle' => true,
                    'selectors' => [
                      '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'margin: {{VALUE}}!important; display:block!important;',
                    ],
                    'condition' => [ 
                        'button_position' => 'relative',
                      ],
                ]
            );
        
            $this->add_control(
                'font_size',
                [
                    'label' => esc_html__( 'Font Size  ', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 1000,
                    'step' => 1,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => ' font-size: {{VALUE}}px!important; ',
                    ],
                ]
            );
            $this->add_control(
                'button_height',
                [
                    'label' => esc_html__( 'Button  Height', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 1000,
                    'step' => 1,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => ' line-height: {{VALUE}}px!important; min-height: {{VALUE}}px!important;',
                    ],
                ]
            );
            
            $this->add_control(
                'button_width',
                [
                    'label' => esc_html__( 'Button  Width', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 1000,
                    'step' => 1,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'width: {{VALUE}}px!important; min-width: {{VALUE}}px!important;',
                    ],
                ]
            );

                
            $this->add_control(
                'button_border_radius',
                [
                    'label' => esc_html__( 'Button Border Radius', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'button_border',
                [
                    'label' => esc_html__( 'Button Border Width', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="submit"]  ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'button_border_stylesss',
                [
                'label' => __('Button Border Styles', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                  '' => __( 'Select', 'vankine-addons' ),
                    'solid' => __( 'Solid', 'vankine-addons' ),
                    'dotted' => __( 'Dotted', 'vankine-addons' ),
                    'dashed' => __( 'Dashed', 'vankine-addons' ),
                    'double' => __( 'Double', 'vankine-addons' ),
                    'none' => __( 'None', 'vankine-addons' ),
                ],
                'default' => __('' , 'vankine-addons'),
                'selectors' => [
                    '{{WRAPPER}} .newsteller_simple input[type="submit"]  ' => 'border-style: {{VALUE}}!important;',
                ],
                ]
            );
            
            $this->add_control(
                'button_border_color',
                 [
                    'label' => __('Button Border Color', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'border-color: {{VALUE}}!important;',
                    ],
                 ]
            );
            
            $this->add_control(
                'button_color',
                 [
                    'label' => __('Button   Color', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsteller_simple input[type="submit"] ' => 'color: {{VALUE}}!important;',
                    ],
                 ]
            );
            $this->add_control(
                'bgh1',
                    [
                    'type' => \Elementor\Controls_Manager::DIVIDER, 
                    ]
                );
     
            $this->add_group_control(
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'button_bg',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .newsteller_simple input[type="submit"] ',
                ]
            );
            $this->add_control(
                'bgh2',
                    [
                    'type' => \Elementor\Controls_Manager::DIVIDER, 
                    ]
                );
          
            $this->add_group_control( 
                \Elementor\Group_Control_Background::get_type(),
                [

                    'name' => 'button_bg_hover',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .newsteller_simple input[type="submit"]:hover ',
                ]
            );
            
 
       
        $this->end_controls_section();
    }
   
       protected function render()
       {
           $settings = $this->get_settings_for_display();
   
           $allowed_tags = wp_kses_allowed_html('post');
   
   ?>

<div class="newsteller_simple">
    <div class="input_group">
        <?php echo do_shortcode( $settings['subscribe_shortcode'] );?>
    </div>
</div>

  
<?php
}
}
 