<?php
/**
 * Plugin Name: Vankine Addons
 * Plugin URI: http://steelthemes.com
 * Description: Extra Addons For Vankine theme. 
 * Version: 1.2.6
 * Author:  Steelthemes
 * Author URI: https://themeforest.net/user/steelthemes
 * License: GPL2+
 * Text Domain: vankine-addons
 * Domain Path: /lang/
 */
if( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if(!defined('VANKINE_ADDONS_DIR')){
    define('VANKINE_ADDONS_DIR', plugin_dir_path( __FILE__ ));
}
  
if(!defined('VANKINE_ADDONS_URL')){
    define('VANKINE_ADDONS_URL', plugin_dir_url( __FILE__ ));
}
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;
  
require_once __DIR__ . '/vendor/autoload.php';
/**
* Main Vankine Addons Class
*
* The main class that initiates and runs the plugin.
*
* @since 1.0.0
*/
final class Vankine_elementor_extension {

	/**
	 * Addon Version
	 *
	 * @since 1.0.0
	 * @var string The addon version.
	 */
	const VERSION = '1.0.0';

	/**
	 * Minimum Elementor Version
	 *
	 * @since 1.0.0
	 * @var string Minimum Elementor version required to run the addon.
	 */
	const MINIMUM_ELEMENTOR_VERSION = '3.7.0';

	/**
	 * Minimum PHP Version
	 *
	 * @since 1.0.0
	 * @var string Minimum PHP version required to run the addon.
	 */
	const MINIMUM_PHP_VERSION = '7.3';

	/**
	 * Instance
	 *
	 * @since 1.0.0
	 * @access private
	 * @static
	 * @var Vankine_elementor_extension The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @access public
	 * @static
	 * @return Vankine_elementor_extension An instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	/**
	 * Constructor
	 *
	 * Perform some compatibility checks to make sure basic requirements are meet.
	 * If all compatibility checks pass, initialize the functionality.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function __construct() {

        add_action( 'init', [ $this, 'i18n' ] );
        add_action( 'plugins_loaded', [ $this, 'on_plugins_loaded' ] );
        remove_filter( 'render_block', 'wp_render_layout_support_flag', 10, 2 );
        $this->add_vankine_extra();
        $this->update_theme_plugin();
        $this->get_shortcodes();
        add_filter( 'init', array( $this, 'enable_elementor_posttype_supports' ));
	}
    /**
    * Theme Update
    **/
    public function update_theme_plugin() {
        require_once VANKINE_ADDONS_DIR . '/update/plugin-update-checker.php';
        $myUpdateCheckers = PucFactory::buildUpdateChecker(
        'https://themepanthers.com/updatedplugin/vankine/plugin.json',
        __FILE__, //Full path to the main plugin file or functions.php.
        'vankine-plugin-addons'
        );
    }

    public function enable_elementor_posttype_supports() {
        $elementor_enable = get_option( 'elementor_cpt_support' );
        if ( ! $elementor_enable ) {
            $elementor_enable = array( 'page', 'post', 'product', 'header' , 'service' , 'portfolio' , 'footer' , 'mega_menu' );
            update_option( 'elementor_cpt_support', $elementor_enable );
        }  
    }

    /**
    * Get All the wanted files
    *
    * @return void
    */
    public function add_vankine_extra(){
       // require_once VANKINE_ADDONS_DIR . '/includes/theme-panel/theme-panel.php';
        require_once VANKINE_ADDONS_DIR . '/includes/Plugins/Widgets/recent-post.php';
        require_once VANKINE_ADDONS_DIR . '/includes/Plugins/Widgets/about-us.php';
        require_once VANKINE_ADDONS_DIR . '/update.php';
        require_once VANKINE_ADDONS_DIR . '/includes/Customicons/Customicons.php';
        
 
        if (!class_exists('Redux' )){
            require_once VANKINE_ADDONS_DIR . 'redux-framework/redux-framework.php';
            require_once VANKINE_ADDONS_DIR . 'metabox/metaboxes.php';
        }
        add_action('elementor/editor/before_enqueue_scripts', function() {
            wp_enqueue_style('vankine-widgets-icon', VANKINE_ADDONS_URL . '/assets/fonts/style.css', array() , '1.0.0', 'all'); 
            wp_enqueue_style('vankine-widgets-css', VANKINE_ADDONS_URL . '/assets/css/elementor-vankine.css', array() , '1.0.0', 'all'); 
        });
    }
    public function on_plugins_loaded(){
        new Vankineaddons\Startvankine();
        new Vankineaddons\Admin();
        if ($this->is_compatible()) {
            add_action('elementor/init', [$this, 'init']);
        }
    }
    /*
    ** ============================== 
    **   get_shortcodes
    ** ==============================
    */ 
    public function get_shortcodes() {
        /*
        ** ============================== 
        **  vankine_navmenu
        ** ==============================
        */ 
        if (!function_exists('vankine_navmenu')) {
            function vankine_navmenu() {
                $options = array();
                $nvmenus = wp_get_nav_menus();
                    if (!empty($nvmenus)) {
                        foreach ($nvmenus as $navigationmenu) {
                            if (isset($navigationmenu)) {
                                $options[''] = 'Select';
                                if (isset($navigationmenu->slug) && isset($navigationmenu->name)) {
                                    $options[$navigationmenu->slug] = $navigationmenu->name;
                                }
                            }
                        }
                    }
                
                return $options;
            }
        }
        
        /*
        ** ============================== 
        **   vankine_navmenu
        ** ==============================
        */ 
         

        // Ensure this function exists in your theme functions or class implementation
if (!function_exists('vankine_get_icon')) {

    function vankine_get_icon() {
        $cache_file = get_stylesheet_directory() . '/icons_cache.json';
        $cache_expiration = 24 * 60 * 60; // 24 hours 
        $icons = array();
    
        if (file_exists($cache_file) && (time() - filemtime($cache_file) < $cache_expiration)) {
            $icons = json_decode(file_get_contents($cache_file), true);
        } else {
            error_log('Updating icon cache.');
    
            // Scrape list of icons from fontawesome css
            $pattern = '/\.((?:\w+(?:-)?)+):before\s*{\s*content/';
            $subject = file_get_contents(get_stylesheet_directory() . '/assets/css/plugins/uicons-regular-rounded.css');
            if ($subject === false) {
                error_log('Failed to read font-awesome.min.css');
            } else {
                preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);
                foreach ($matches as $match) {
                    $icons[] = array('value' => ''.$match[1], 'label' => $match[1]);
                }
            }
    
            // Scrape list of icons from iconmoon css
            $patterniconmoo = '/\.((?:\w+(?:-)?)+):before\s*{\s*content/';
            $subjectwoicon = file_get_contents(get_stylesheet_directory() . '/assets/css/plugins/uicons-regular-straight.css'); 
            if ($subjectwoicon === false) {
                error_log('Failed to read style.css');
            } else {
                preg_match_all($patterniconmoo, $subjectwoicon, $matchestwoiocn, PREG_SET_ORDER);
                foreach ($matchestwoiocn as $match) {
                    $icons[] = array('value' => ''.$match[1], 'label' => $match[1]);
                }
            }

             // Scrape list of icons from iconmoon css
             $patterniconmooss = '/\.((?:\w+(?:-)?)+):before\s*{\s*content/';
             $subjectwoiconsss = file_get_contents(get_stylesheet_directory() . '/assets/css/plugins/flaticon_vankine.css'); 
             if ($subjectwoiconsss === false) {
                 error_log('Failed to read style.css');
             } else {
                 preg_match_all($patterniconmooss, $subjectwoiconsss, $matchestwoiocnsss, PREG_SET_ORDER);
                 foreach ($matchestwoiocnsss as $match) {
                     $icons[] = array('value' => ''.$match[1], 'label' => $match[1]);
                 }
             }
             
            // Add icons from icons.css with a more generic pattern
            $patterntwo = '/\.([\w-]+):before\s*{\s*content/';
            $subjectwo = file_get_contents(get_stylesheet_directory() . '/assets/css/icons.css'); 
            if ($subjectwo === false) {
                error_log('Failed to read icons.css');
            } else {
                preg_match_all($patterntwo, $subjectwo, $matchestwo, PREG_SET_ORDER);
                if (empty($matchestwo)) {
                    error_log('No matches found in icons.css');
                }
                foreach ($matchestwo as $match) {
                    $icons[] = array('value' => $match[1], 'label' => $match[1]);
                }
            }
    
            // Format the array to have the label as keys and value as values
            $icons = array_column($icons, 'label', 'value');
    
            // Save icons to cache
            $result = file_put_contents($cache_file, json_encode($icons));
            if ($result === false) {
                error_log('Failed to write icons cache');
            }
        }
    
        return $icons;
    }
}
    
        /*
        ** ============================== 
        **   vankine_contact_form_7_query
        ** ==============================
        */ 
        if (!function_exists('vankine_contact_form_7_query')):
            function vankine_contact_form_7_query($post_type){
            $post_list = get_posts(array(
                'post_type' => $post_type,
                'showposts' => -1,
            ));
            $posts = array();
                if (!empty($post_list) && !is_wp_error($post_list)) {
                    foreach ($post_list as $post) {
                        $options[$post->ID] = $post->post_title;
                }
                return $options;
            }
        }
        endif;
        /*
        ** ============================== 
        **   vankine_contact_form_7_query
        ** ==============================
        */ 
        if (!function_exists('vankine_product_query')):
            function vankine_product_query(){
            $post_list = get_posts(array(
                'post_type' => 'product',
                'showposts' => -1,
            ));
            $posts = array();
                if (!empty($post_list) && !is_wp_error($post_list)) {
                    foreach ($post_list as $post) {
                        $options[$post->ID] = $post->post_title;
                }
                return $options;
            }
        }
        endif;
       
        /*
        ** ============================== 
        ** vankine_get_blog_categories
        ** ============================== 
        */
        function vankine_get_blog_categories() {
            $options = array();
            $taxonomy = 'category';
            if (!empty($taxonomy)) {
                $terms = get_terms(
                    array(
                        'parent' => 0,
                        'taxonomy' => $taxonomy,
                        'hide_empty' => false,
                        )
                    );
                    if (!empty($terms)) {
                        foreach ($terms as $term) {
                            if (isset($term)) {
                                $options[''] = 'Select';
                                if (isset($term->slug) && isset($term->name)) {
                                    $options[$term->slug] = $term->name;
                                }
                            }
                        }
                    }
                }
            return $options;
        }
        /*
        ** ============================== 
        ** vankine_get_portfolio_categories
        ** ============================== 
        */
        function vankine_get_portfolio_categories() {
            $options = array();
            $taxonomy = 'portfolio_category';
            if (!empty($taxonomy)) {
                $terms = get_terms(
                    array(
                        'parent' => 0,
                        'taxonomy' => $taxonomy,
                        'hide_empty' => false,
                        )
                    );
                    if (!empty($terms)) {
                        foreach ($terms as $term) {
                            if (isset($term)) {
                                $options[''] = 'Select';
                                if (isset($term->slug) && isset($term->name)) {
                                    $options[$term->slug] = $term->name;
                                }
                            }
                        }
                    }
                }
            return $options;
        }
        /*
        ** ============================== 
        ** vankine_get_product_categories
        ** ============================== 
        */
        function vankine_get_product_categories() {
            $options = array();
            $taxonomy = 'product_category';
            if (!empty($taxonomy)) {
                $terms = get_terms(
                    array(
                        'parent' => 0,
                        'taxonomy' => $taxonomy,
                        'hide_empty' => false,
                        )
                    );
                    if (!empty($terms)) {
                        foreach ($terms as $term) {
                            if (isset($term)) {
                                $options[''] = 'Select';
                                if (isset($term->slug) && isset($term->name)) {
                                    $options[$term->slug] = $term->name;
                                }
                            }
                        }
                    }
                }
            return $options;
        }
        /*
        ** ============================== 
        ** vankine_get_service_categories
        ** ============================== 
        */
        function vankine_get_service_categories() {
            $options = array();
            $taxonomy = 'service_category';
            if (!empty($taxonomy)) {
                $terms = get_terms(
                    array(
                        'parent' => 0,
                        'taxonomy' => $taxonomy,
                        'hide_empty' => false,
                        )
                    );
                    if (!empty($terms)) {
                        foreach ($terms as $term) {
                            if (isset($term)) {
                                $options[''] = 'Select';
                                if (isset($term->slug) && isset($term->name)) {
                                    $options[$term->slug] = $term->name;
                                }
                            }
                        }
                    }
                }
            return $options;
        }
    
        
    
    }
     /**
     * Load Textdomain
     *
     * Load plugin localization files.
     *
     * Fired by `init` action hook.
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function i18n() {
        load_theme_textdomain( 'vankine-addons', get_template_directory() . '/lang' );
    }
	/**
	 * Compatibility Checks
	 *
	 * Checks whether the site meets the addon requirement.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function is_compatible() {

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return false;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return false;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return false;
		}

		return true;

	}

    /**
     * Initialize the plugin
     *
     * Load the plugin only after Elementor (and other plugins) are loaded.
     * Checks for basic plugin requirements, if one check fail don't continue,
     * if all check have passed load the files required to run the plugin.
     *
     * Fired by `plugins_loaded` action hook.
     *
     * @since 1.0.0
     *
     * @access public
    */
    public function init() {
        $this->i18n();
        // Register widgets
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
    }

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have Elementor installed or activated.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'vankine-addons' ),
			'<strong>' . esc_html__( 'Vankine Addons', 'vankine-addons' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'vankine-addons' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required Elementor version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'vankine-addons' ),
			'<strong>' . esc_html__( 'Vankine Addons', 'vankine-addons' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'vankine-addons' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'vankine-addons' ),
			'<strong>' . esc_html__( 'Vankine Addons', 'vankine-addons' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'vankine-addons' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	 /**
     * Include Files
     *
     * Load required plugin core files.
     *
     * @since 1.0.0
     * 
     * @access public
    */
    public function register_widgets() {
        $widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
        //header
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Header\Header_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Header\Header_v2());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Header\Logo());

        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Header\Side_menu_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Header\Extra_items_btn_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Header\Contact_header_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Header\Menu_v1());
        //Content
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Price_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Text_editor());

        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Image_box_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Progress_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Team_box_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Mcforwp_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Tab_with_content_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Faqs_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Process_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Testivertical_carousel_v1()); 
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Testi_carousel_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Icon_box());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Title_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Theme_btn_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Social_media_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\List_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Contact_box_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Contact_form_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Fun_facts_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Content\Sidebar_v1());
        //post
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Post\Portfolio_Carousel_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Post\Blog_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Post\Service_v1());   
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Post\Service_carousel_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Post\Portfolio_filter_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Post\Portfolio_post_v2()); 
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Post\Product_v1()); 
      
        //Footer
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Footer\Foo_gallery_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Footer\Foo_post_v1());
        $widgets_manager->register(new  Vankineaddons\Core\Widgets\Footer\Foo_contact_v1());


    }

}
Vankine_elementor_extension::instance();